/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.PropertyInputDialog;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.PropertyStyleBaseTableControl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyXMLStyleChildTableControl
extends PropertyStyleBaseTableControl {
    private Element inputElement;

    public PropertyXMLStyleChildTableControl(Composite parent, int style) {
        this(parent, style, false);
    }

    public PropertyXMLStyleChildTableControl(Composite parent, int style, boolean isReadOnly) {
        super(parent, style, isReadOnly);
        this.propertyTreeTable.setInput((Object)this.inputElement);
        this.updatePropertyTypeButtons();
    }

    @Override
    protected void removePropertyFromList() {
        if (!this.getStructuredSelection().isEmpty()) {
            Element selectedProperty = (Element)this.getStructuredSelection().getFirstElement();
            this.inputElement.removeChild(selectedProperty);
        }
    }

    @Override
    protected void addPropertyTypeToList() {
        PropertyInputDialog dialog = new PropertyInputDialog(Display.getCurrent().getActiveShell());
        dialog.setInput(this.inputElement);
        int rtnValue = dialog.open();
        if (rtnValue == 0) {
            String name = dialog.getPropertyName();
            String value = dialog.getPropertyValue();
            this.addBeanProperty(name, value);
        }
    }

    @Override
    protected void editPropertyType() {
        if (!this.getStructuredSelection().isEmpty()) {
            Element selectedProperty = (Element)this.getStructuredSelection().getFirstElement();
            PropertyInputDialog dialog = new PropertyInputDialog(Display.getCurrent().getActiveShell());
            dialog.setIsEditDialog(true);
            Element xmlElement = selectedProperty;
            if (xmlElement.getAttribute("name") != null) {
                dialog.setPropertyName(xmlElement.getAttribute("name"));
            }
            if (xmlElement.getAttribute("value") != null) {
                dialog.setPropertyValue(xmlElement.getAttribute("value"));
            }
            dialog.setInput(this.inputElement);
            int rtnValue = dialog.open();
            if (rtnValue == 0) {
                String name = dialog.getPropertyName();
                String value = dialog.getPropertyValue();
                this.beanConfigUtil.editBeanProperty(xmlElement, name, value);
            }
        }
    }

    public void setInput(Element input) {
        this.inputElement = input;
        if (this.propertyTreeTable != null && !this.propertyTreeTable.getControl().isDisposed()) {
            this.propertyTreeTable.setInput((Object)this.inputElement);
        }
    }

    @Override
    protected void addBeanProperty(String name, String value) {
        Element propertyNode = this.beanConfigUtil.createBeanProperty(this.inputElement, name, value);
        this.inputElement.appendChild(propertyNode);
    }

    @Override
    protected ITableLabelProvider getTableLabelProvider() {
        return new PropertyTypeTreeLabelProvider();
    }

    @Override
    protected ITreeContentProvider getTableContentProvider() {
        return new PropertyTypeTreeContentProvider();
    }

    private class PropertyTypeTreeContentProvider
    implements ITreeContentProvider {
        private PropertyTypeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Element) {
                Element parent = (Element)inputElement;
                return this.convertToArray(parent.getElementsByTagName("property"));
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof Element) {
                return ((Element)element).getParentNode();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Element) {
                return ((Element)element).hasChildNodes();
            }
            return false;
        }

        private Object[] convertToArray(NodeList list) {
            int length = list.getLength();
            Object[] copy = new Node[length];
            int n = 0;
            while (n < length) {
                copy[n] = list.item(n);
                ++n;
            }
            return copy;
        }
    }

    private class PropertyTypeTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTypeTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return element instanceof Element && (property.equalsIgnoreCase("name") || property.equalsIgnoreCase("value"));
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Element && columnIndex == 0) {
                Element xmlElement = (Element)element;
                return xmlElement.getAttribute("name");
            }
            if (element instanceof Element && columnIndex == 1) {
                Element xmlElement = (Element)element;
                return xmlElement.getAttribute("value");
            }
            return null;
        }
    }
}

