/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.AddGlobalBeanWizard;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.EditGlobalBeanWizard;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigElementType;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.provider.ext.ICustomGlobalConfigElementContribution;
import org.fusesource.ide.camel.editor.utils.GlobalConfigUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Node;

public class GlobalBeanContributor
implements ICustomGlobalConfigElementContribution {
    private AddGlobalBeanWizard wizard = null;
    private GlobalConfigUtils globalConfigUtils = null;
    private BeanConfigUtil beanConfigUtil = new BeanConfigUtil();

    @Override
    public GlobalConfigurationTypeWizard createGlobalElement(CamelFile camelFile) {
        this.wizard = this.createAddWizard(camelFile);
        return this.wizard;
    }

    @Override
    public GlobalConfigurationTypeWizard modifyGlobalElement(CamelFile camelFile) {
        return this.createEditWizard(camelFile);
    }

    @Override
    public List<Dependency> getElementDependencies() {
        Component component;
        if (this.wizard != null && (component = this.wizard.getComponent()) != null) {
            return component.getDependencies();
        }
        return Collections.emptyList();
    }

    @Override
    public void onGlobalElementDeleted(AbstractCamelModelElement camelModelElement) {
    }

    @Override
    public boolean canHandle(AbstractCamelModelElement camelModelElementToHandle) {
        if (this.globalConfigUtils == null) {
            this.setGlobalConfigUtils(new GlobalConfigUtils());
        }
        boolean isGlobalBeanElement = CamelUtils.isGlobalBean((Node)camelModelElementToHandle.getXmlNode());
        boolean isSAPClass = true;
        if (isGlobalBeanElement) {
            Object classParm = camelModelElementToHandle.getParameter("class");
            if (classParm instanceof String && !Strings.isEmpty((String)((String)classParm))) {
                isSAPClass = "org.fusesource.camel.component.sap.SapConnectionConfiguration".equals((String)classParm);
            } else {
                String refParm = this.beanConfigUtil.getBeanRef(camelModelElementToHandle);
                if (!Strings.isEmpty((String)refParm)) {
                    isSAPClass = false;
                }
            }
        }
        if (!this.globalConfigUtils.isSAPExtInstalled() || !isSAPClass) {
            return isGlobalBeanElement;
        }
        return false;
    }

    @Override
    public GlobalConfigElementType getGlobalConfigElementType() {
        return GlobalConfigElementType.GLOBAL_BEAN;
    }

    private EditGlobalBeanWizard createEditWizard(CamelFile camelFile) {
        IProject project = camelFile.getResource().getProject();
        CamelModel camelModel = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
        EditGlobalBeanWizard editWizard = new EditGlobalBeanWizard(camelFile, camelModel);
        editWizard.init();
        return editWizard;
    }

    private AddGlobalBeanWizard createAddWizard(CamelFile camelFile) {
        IProject project = camelFile.getResource().getProject();
        CamelModel camelModel = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
        AddGlobalBeanWizard addWizard = new AddGlobalBeanWizard(camelFile, camelModel);
        addWizard.init();
        return addWizard;
    }

    public void setGlobalConfigUtils(GlobalConfigUtils globalConfigUtils) {
        this.globalConfigUtils = globalConfigUtils;
    }
}

