/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.validation;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBean;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;

public class BeanValidationUtil {
    private BeanValidationUtil() {
    }

    public static IStatus validateIdInParent(AbstractCamelModelElement parent, Object value) {
        String id;
        Object elementToSearchIn = parent instanceof CamelBean ? parent.getCamelFile() : parent;
        if (elementToSearchIn.findAllNodesWithId(id = (String)value).size() > 1) {
            return ValidationStatus.error((String)UIMessages.newBeanIdValidatorErrorBeanIDAlreadyUsed);
        }
        return ValidationStatus.ok();
    }

    public static IStatus validateRequiredParameter(Parameter parameter, Object value) {
        if (PropertiesUtils.isRequired((Parameter)parameter) && (value == null || value.toString().trim().length() < 1)) {
            return ValidationStatus.error((String)NLS.bind((String)UIMessages.propertyRequiredValidatorMandatoryParameterEmptyPt, (Object)parameter.getName()));
        }
        return ValidationStatus.ok();
    }
}

