/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Combo;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;

public class BeanClassExistsValidator
implements IValidator {
    private IObservableMap<?, ?> modelMap = null;
    private IProject project;
    private AbstractCamelModelElement parent = null;
    private Combo beanRefIdCombo = null;
    protected BeanConfigUtil beanConfigUtil = new BeanConfigUtil();
    private String factoryBeanTag = null;
    private IJavaProject javaProject = null;

    public BeanClassExistsValidator(IProject project) {
        this.project = project;
        this.javaProject = JavaCore.create((IProject)this.project);
    }

    public BeanClassExistsValidator(IProject project, AbstractCamelModelElement element) {
        this(project);
        this.parent = element;
        this.factoryBeanTag = this.beanConfigUtil.getFactoryBeanTag(element.getXmlNode());
    }

    public BeanClassExistsValidator(IProject project, AbstractCamelModelElement element, Combo refCombo) {
        this(project, element);
        this.beanRefIdCombo = refCombo;
    }

    public BeanClassExistsValidator(IProject project, AbstractCamelModelElement element, IObservableMap<?, ?> modelMap) {
        this(project, element);
        this.modelMap = modelMap;
    }

    public void setControl(Combo control) {
        this.beanRefIdCombo = control;
    }

    private IStatus classExistsInProject(String className) {
        try {
            IType javaClass;
            IType iType = javaClass = this.javaProject == null ? null : this.javaProject.findType(className);
            if (javaClass == null) {
                return ValidationStatus.error((String)UIMessages.beanClassExistsValidatorErrorBeanClassMustExist);
            }
        }
        catch (JavaModelException e) {
            return ValidationStatus.error((String)UIMessages.beanClassExistsValidatorErrorBeanClassMustExist, (Throwable)e);
        }
        return ValidationStatus.ok();
    }

    private String getBeanReferenceId() {
        String beanRefId = null;
        if (this.beanRefIdCombo != null && !this.beanRefIdCombo.isDisposed()) {
            beanRefId = this.beanRefIdCombo.getText();
        } else if (this.modelMap != null) {
            String className;
            Object control = this.modelMap.get((Object)"class");
            if (control != null && Strings.isEmpty((String)(className = (String)control)) && !Strings.isEmpty((String)this.factoryBeanTag)) {
                beanRefId = (String)this.modelMap.get((Object)this.factoryBeanTag);
            }
        } else if (this.parent != null && this.parent.getParameter(this.factoryBeanTag) != null) {
            beanRefId = (String)this.parent.getParameter(this.factoryBeanTag);
        }
        return beanRefId;
    }

    public IStatus validate(Object value) {
        String className = (String)value;
        if (!Strings.isEmpty((String)className)) {
            String beanRefId = this.getBeanReferenceId();
            IStatus firstStatus = this.classExistsInProject(className);
            if (Strings.isEmpty((String)className) && firstStatus != ValidationStatus.ok() && !Strings.isEmpty((String)beanRefId)) {
                String referencedClassName = this.beanConfigUtil.getClassNameFromReferencedCamelBean(this.parent, beanRefId);
                return this.classExistsInProject(referencedClassName);
            }
            return firstStatus;
        }
        return ValidationStatus.ok();
    }
}

