/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;

public class BeanRefClassExistsValidator
implements IValidator {
    private IObservableMap<?, ?> modelMap = null;
    private IProject project;
    private AbstractCamelModelElement parent;
    private Text beanClassText = null;
    protected BeanConfigUtil beanConfigUtil = new BeanConfigUtil();
    private IJavaProject javaProject = null;

    public BeanRefClassExistsValidator(IProject project) {
        this.project = project;
        this.javaProject = JavaCore.create((IProject)this.project);
    }

    public BeanRefClassExistsValidator(IProject project, AbstractCamelModelElement element) {
        this(project);
        this.parent = element;
    }

    public BeanRefClassExistsValidator(IProject project, AbstractCamelModelElement element, Text control) {
        this(project, element);
        this.beanClassText = control;
    }

    public BeanRefClassExistsValidator(IProject project, AbstractCamelModelElement element, IObservableMap<?, ?> modelMap) {
        this(project, element);
        this.modelMap = modelMap;
    }

    public void setControl(Text textControl) {
        this.beanClassText = textControl;
    }

    private IStatus classExistsInProject(String className) {
        try {
            IType javaClass;
            IType iType = javaClass = this.javaProject == null ? null : this.javaProject.findType(className);
            if (javaClass == null) {
                return ValidationStatus.error((String)UIMessages.beanClassExistsValidatorErrorBeanClassMustExist);
            }
        }
        catch (JavaModelException e) {
            return ValidationStatus.error((String)UIMessages.beanClassExistsValidatorErrorBeanClassMustExist, (Throwable)e);
        }
        return ValidationStatus.ok();
    }

    public IStatus validate(Object value) {
        String beanRefId = (String)value;
        if (!Strings.isEmpty((String)beanRefId)) {
            Object control;
            String className = null;
            if (this.beanClassText != null && !this.beanClassText.isDisposed()) {
                className = this.beanClassText.getText();
            } else if (this.modelMap != null && (control = this.modelMap.get((Object)"class")) != null) {
                className = (String)control;
            }
            String referencedClassName = this.beanConfigUtil.getClassNameFromReferencedCamelBean(this.parent, beanRefId);
            IStatus firstStatus = this.classExistsInProject(referencedClassName);
            if (firstStatus != ValidationStatus.ok() && !Strings.isEmpty((String)className)) {
                return this.classExistsInProject(className);
            }
        }
        return ValidationStatus.ok();
    }
}

