/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.navigator.CamelCtxNavRouteNode;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.ui.util.Widgets;

public class CamelCtxNavContentProvider
implements ICommonContentProvider,
IResourceChangeListener {
    public static final Object JOB_FAMILY = new Object();
    private AbstractTreeViewer mViewer;
    private Job job;
    private Map<IFile, Object[]> contents = new HashMap<IFile, Object[]>();

    public CamelCtxNavContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IFile) {
            return this.getRoutes((IFile)parent);
        }
        return new Object[0];
    }

    private Object[] getRoutes(IFile camelFile) {
        if (!this.contents.containsKey(camelFile)) {
            this.doDeferredLoad(camelFile);
            this.contents.put(camelFile, new Object[]{new LoadingPlaceHolder()});
        }
        return this.contents.get(camelFile);
    }

    private void doDeferredLoad(IFile camelFile) {
        this.job = new LoadingCamelRoutesForNavigatorViewerJob(NLS.bind((String)UIMessages.loadingCamelFile, (Object)camelFile.getName(), (Object)camelFile.getProject().getName()), camelFile);
        this.job.schedule();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || element instanceof CamelCtxNavRouteNode && this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.mViewer = (AbstractTreeViewer)viewer;
        }
    }

    public void dispose() {
        if (this.job != null) {
            this.job.cancel();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)new DeltaWalker());
        }
        catch (CoreException ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    private class DeltaWalker
    implements IResourceDeltaVisitor {
        private DeltaWalker() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (CamelCtxNavContentProvider.this.contents.containsKey(resource) && !Widgets.isDisposed((Viewer)CamelCtxNavContentProvider.this.mViewer)) {
                CamelCtxNavContentProvider.this.contents.remove(resource);
                Display.getDefault().asyncExec(() -> CamelCtxNavContentProvider.this.mViewer.refresh());
                return false;
            }
            return true;
        }
    }

    private final class LoadingCamelRoutesForNavigatorViewerJob
    extends Job {
        private final IFile camelFile;

        private LoadingCamelRoutesForNavigatorViewerJob(String name, IFile camelFile) {
            super(name);
            this.camelFile = camelFile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            CamelCtxNavRouteNode[] routes = this.getRoutes(this.camelFile, monitor);
            if (routes != null) {
                CamelCtxNavContentProvider.this.contents.put(this.camelFile, routes);
                Display.getDefault().asyncExec(() -> {
                    if (!Widgets.isDisposed((Viewer)CamelCtxNavContentProvider.this.mViewer)) {
                        CamelCtxNavContentProvider.this.mViewer.refresh(true);
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private CamelCtxNavRouteNode[] getRoutes(IFile camelFile, IProgressMonitor monitor) {
            CamelIOHandler ioHandler = new CamelIOHandler();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            CamelFile rc = ioHandler.loadCamelModel((IResource)camelFile, (IProgressMonitor)subMonitor.newChild(1));
            if (rc != null && rc.getRouteContainer() != null) {
                return (CamelCtxNavRouteNode[])rc.getRouteContainer().getChildElements().stream().filter(node -> node instanceof CamelRouteElement).map(route -> new CamelCtxNavRouteNode((CamelRouteElement)route, camelFile)).toArray(CamelCtxNavRouteNode[]::new);
            }
            return new CamelCtxNavRouteNode[0];
        }

        public boolean belongsTo(Object family) {
            return JOB_FAMILY.equals(family) || super.belongsTo(family);
        }
    }

    private static class LoadingPlaceHolder {
        private LoadingPlaceHolder() {
        }

        public String toString() {
            return UIMessages.pending;
        }
    }
}

