/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.fusesource.ide.camel.editor.properties.FusePropertySection;
import org.fusesource.ide.camel.editor.properties.ParameterPriorityComparator;
import org.fusesource.ide.camel.editor.properties.creators.TextParameterPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.details.BooleanParameterPropertyUICreatorForDetails;
import org.fusesource.ide.camel.editor.properties.creators.details.DescriptionParameterPropertyUICreator;
import org.fusesource.ide.camel.editor.properties.creators.details.FileParameterPropertyUICreatorForDetails;
import org.fusesource.ide.camel.editor.properties.creators.details.NumberParameterPropertyUICreatorForDetails;
import org.fusesource.ide.camel.editor.properties.creators.details.UnsupportedParameterPropertyUICreatorForDetails;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.camel.validation.model.RefOrDataFormatUnicityChoiceValidator;
import org.fusesource.ide.foundation.core.util.Strings;

public class DetailsSection
extends FusePropertySection {
    @Override
    protected void createContentTabs(CTabFolder folder) {
        List props = PropertiesUtils.getPropertiesFor((AbstractCamelModelElement)this.selectedEP);
        if (props.isEmpty()) {
            return;
        }
        boolean createGeneralTab = false;
        ArrayList<String> tabsToCreate = new ArrayList<String>();
        for (Parameter p : props) {
            String parameterGroup = p.getGroup();
            if (parameterGroup != null && parameterGroup.trim().length() > 0 && !tabsToCreate.contains(parameterGroup)) {
                tabsToCreate.add(parameterGroup);
                continue;
            }
            if (parameterGroup != null && parameterGroup.trim().length() >= 1) continue;
            createGeneralTab = true;
        }
        if (tabsToCreate.isEmpty() || createGeneralTab) {
            tabsToCreate.add("General");
        }
        for (String group : tabsToCreate) {
            CTabItem contentTab = new CTabItem(this.tabFolder, 0);
            contentTab.setText(Strings.humanize((String)group));
            Composite page = this.toolkit.createComposite((Composite)folder);
            page.setLayout((Layout)new GridLayout(4, false));
            this.generateTabContents(props, page, false, group);
            contentTab.setControl((Control)page);
            this.tabs.add(contentTab);
        }
    }

    protected void generateTabContents(List<Parameter> props, final Composite page, boolean ignorePathProperties, String group) {
        props.sort(new ParameterPriorityComparator());
        Iterator<Parameter> iterator = props.iterator();
        while (iterator.hasNext()) {
            String value;
            CCombo choiceCombo;
            Parameter p;
            final Parameter prop = p = iterator.next();
            String currentPropertyGroup = prop.getGroup();
            if (this.shouldHidePropertyFromGroup(group, p, currentPropertyGroup)) continue;
            ISWTObservableValue uiObservable = null;
            ISWTObservableList uiListObservable = null;
            Object validator = null;
            this.createPropertyLabel(this.toolkit, page, p);
            org.eclipse.swt.widgets.List c = null;
            if (CamelComponentUtils.isDescriptionProperty((Parameter)prop)) {
                new DescriptionParameterPropertyUICreator(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isBooleanProperty((Parameter)prop)) {
                new BooleanParameterPropertyUICreatorForDetails(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isTextProperty((Parameter)prop) || CamelComponentUtils.isCharProperty((Parameter)prop)) {
                new TextParameterPropertyUICreator(this.dbc, this.modelMap, this.eip, this.selectedEP, p, null, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isNumberProperty((Parameter)prop)) {
                new NumberParameterPropertyUICreatorForDetails(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isChoiceProperty((Parameter)prop)) {
                choiceCombo = new CCombo(page, 0x80080C);
                this.getWidgetFactory().adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setItems(CamelComponentUtils.getChoicesWithExtraEmptyEntry((Parameter)prop));
                value = (String)(this.selectedEP.getParameter(p.getName()) != null ? this.selectedEP.getParameter(p.getName()) : this.eip.getParameter(p.getName()).getDefaultValue());
                int i = 0;
                while (i < choiceCombo.getItems().length) {
                    if (choiceCombo.getItem(i).equalsIgnoreCase(value)) {
                        choiceCombo.select(i);
                        break;
                    }
                    ++i;
                }
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        DetailsSection.this.selectedEP.setParameter(prop.getName(), (Object)choice.getText());
                    }
                });
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isRefProperty((Parameter)prop)) {
                choiceCombo = new CCombo(page, 0x80080C);
                this.getWidgetFactory().adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(true);
                choiceCombo.setItems(CamelComponentUtils.getRefs((CamelFile)this.selectedEP.getCamelFile()));
                value = (String)(this.selectedEP.getParameter(p.getName()) != null ? this.selectedEP.getParameter(p.getName()) : this.eip.getParameter(p.getName()).getDefaultValue());
                boolean selected = false;
                int i = 0;
                while (i < choiceCombo.getItems().length) {
                    if (choiceCombo.getItem(i).equalsIgnoreCase(value)) {
                        choiceCombo.select(i);
                        selected = true;
                        break;
                    }
                    ++i;
                }
                if (!selected && value != null) {
                    choiceCombo.setText(value);
                }
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        DetailsSection.this.selectedEP.setParameter(prop.getName(), (Object)choice.getText());
                    }
                });
                choiceCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        DetailsSection.this.selectedEP.setParameter(prop.getName(), (Object)choice.getText());
                    }
                });
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                validator = new IValidator(){

                    public IStatus validate(Object value) {
                        if (PropertiesUtils.isRequired((Parameter)prop)) {
                            if (value == null || !(value instanceof String) || value.toString().trim().length() < 1) {
                                return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                            }
                        } else if (this.isNotEmptyString(value) && DetailsSection.this.selectedEP.getRouteContainer().findNode((String)value) == null && !DetailsSection.this.selectedEP.getCamelFile().getGlobalDefinitions().containsKey((String)value)) {
                            return ValidationStatus.warning((String)("Parameter " + prop.getName() + " does not point to an existing reference inside the context."));
                        }
                        return new RefOrDataFormatUnicityChoiceValidator(DetailsSection.this.selectedEP, prop).validate(value);
                    }

                    private boolean isNotEmptyString(Object value) {
                        return value != null && value instanceof String && value.toString().trim().length() > 0;
                    }
                };
            } else if (CamelComponentUtils.isFileProperty((Parameter)prop)) {
                new FileParameterPropertyUICreatorForDetails(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if (CamelComponentUtils.isListProperty((Parameter)prop)) {
                org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(page, 0x80080C);
                this.getWidgetFactory().adapt((Control)list, true, true);
                list.setLayoutData((Object)this.createPropertyFieldLayoutData());
                ArrayList listElements = this.selectedEP.getParameter(prop.getName()) != null ? (ArrayList)this.selectedEP.getParameter(prop.getName()) : new ArrayList();
                list.setItems(listElements.toArray(new String[listElements.size()]));
                c = list;
                this.modelMap.put((Object)p.getName(), Arrays.asList(list.getItems()));
                uiListObservable = WidgetProperties.items().observe((Widget)list);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof List && !((List)value).isEmpty()) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isExpressionProperty((Parameter)prop)) {
                choiceCombo = new CCombo(page, 0x80080C);
                this.deactivateMouseWheel(choiceCombo);
                this.getWidgetFactory().adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                AbstractCamelModelElement expressionElement = this.selectedEP.getParameter(prop.getName()) != null ? (AbstractCamelModelElement)this.selectedEP.getParameter(prop.getName()) : null;
                choiceCombo.setItems(CamelComponentUtils.getOneOfList((Parameter)prop));
                final Composite eform = this.getWidgetFactory().createFlatFormComposite(page);
                eform.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).span(4, 1).grab(true, false).create());
                eform.setLayout((Layout)new GridLayout(1, true));
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        String language = choice.getText();
                        DetailsSection.this.languageChanged(language, eform, DetailsSection.this.selectedEP.getParameter(prop.getName()) != null ? (AbstractCamelModelElement)DetailsSection.this.selectedEP.getParameter(prop.getName()) : null, page, prop);
                    }
                });
                if (expressionElement != null) {
                    String value2 = expressionElement.getNodeTypeId();
                    Object expressionParameterValue = expressionElement.getParameter("expression");
                    if (expressionParameterValue != null && expressionParameterValue instanceof AbstractCamelModelElement) {
                        AbstractCamelModelElement ex = (AbstractCamelModelElement)expressionParameterValue;
                        value2 = ex.getTagNameWithoutPrefix();
                    }
                    choiceCombo.deselectAll();
                    int i = 0;
                    while (i < choiceCombo.getItems().length) {
                        if (choiceCombo.getItem(i).equalsIgnoreCase(value2)) {
                            choiceCombo.select(i);
                            this.languageChanged(value2, eform, expressionElement, page, prop);
                            break;
                        }
                        ++i;
                    }
                }
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return ValidationStatus.ok();
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isDataFormatProperty((Parameter)prop)) {
                choiceCombo = new CCombo(page, 0x80080C);
                this.deactivateMouseWheel(choiceCombo);
                this.getWidgetFactory().adapt((Control)choiceCombo, true, true);
                choiceCombo.setEditable(false);
                choiceCombo.setLayoutData((Object)this.createPropertyFieldLayoutData());
                AbstractCamelModelElement dataformatElement = this.selectedEP.getParameter(prop.getName()) != null ? (AbstractCamelModelElement)this.selectedEP.getParameter(prop.getName()) : null;
                choiceCombo.setItems(CamelComponentUtils.getOneOfList((Parameter)prop));
                final Composite eform = this.getWidgetFactory().createFlatFormComposite(page);
                eform.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).span(4, 1).grab(true, false).create());
                eform.setLayout((Layout)new GridLayout(1, true));
                choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CCombo choice = (CCombo)e.getSource();
                        String dataformat = choice.getText();
                        DetailsSection.this.dataFormatChanged(dataformat, eform, DetailsSection.this.selectedEP.getParameter(prop.getName()) != null ? (AbstractCamelModelElement)DetailsSection.this.selectedEP.getParameter(prop.getName()) : null, page, prop);
                    }
                });
                if (dataformatElement != null) {
                    String value3 = dataformatElement.getNodeTypeId();
                    choiceCombo.deselectAll();
                    int i = 0;
                    while (i < choiceCombo.getItems().length) {
                        if (choiceCombo.getItem(i).equalsIgnoreCase(value3)) {
                            choiceCombo.select(i);
                            this.dataFormatChanged(value3, eform, dataformatElement, page, prop);
                            break;
                        }
                        ++i;
                    }
                }
                c = choiceCombo;
                this.modelMap.put((Object)p.getName(), (Object)choiceCombo.getText());
                uiObservable = WidgetProperties.selection().observe((Widget)choiceCombo);
                if (PropertiesUtils.isRequired((Parameter)p)) {
                    validator = new IValidator(){

                        public IStatus validate(Object value) {
                            if (value != null && value instanceof String && value.toString().trim().length() > 0) {
                                return new RefOrDataFormatUnicityChoiceValidator(DetailsSection.this.selectedEP, prop).validate(value);
                            }
                            return ValidationStatus.error((String)("Parameter " + prop.getName() + " is a mandatory field and cannot be empty."));
                        }
                    };
                }
            } else if (CamelComponentUtils.isUnsupportedProperty((Parameter)prop)) {
                new UnsupportedParameterPropertyUICreatorForDetails(this.dbc, this.modelMap, this.eip, this.selectedEP, p, page, this.getWidgetFactory()).create();
            } else if ("redeliveryPolicy".equals(prop.getName())) {
                Object valueToDisplay;
                Object object = valueToDisplay = this.selectedEP.getParameter(p.getName()) != null ? this.selectedEP.getParameter(p.getName()) : this.eip.getParameter(p.getName()).getDefaultValue();
                if (valueToDisplay instanceof AbstractCamelModelElement) {
                    Group objectGroup = this.getWidgetFactory().createGroup(page, "");
                    objectGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
                    objectGroup.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).span(4, 1).grab(true, false).create());
                    CamelModel camelModel = this.getCamelModel((AbstractCamelModelElement)valueToDisplay);
                    Eip eip = camelModel.getEip(prop.getName());
                    for (Parameter childParameter : eip.getParameters()) {
                        this.createPropertyLabel(this.toolkit, (Composite)objectGroup, childParameter);
                        Control field = this.getControlForParameter(childParameter, (Composite)objectGroup, (AbstractCamelModelElement)valueToDisplay, (IParameterContainer)eip);
                        field.setToolTipText(childParameter.getDescription());
                    }
                    c = objectGroup;
                }
            } else {
                new TextParameterPropertyUICreator(this.dbc, this.modelMap, this.eip, this.selectedEP, p, null, page, this.getWidgetFactory()).create();
            }
            Binding bindValue = null;
            if (uiObservable != null) {
                IObservableValue modelObservable = Observables.observeMapEntry((IObservableMap)this.modelMap, (Object)p.getName());
                UpdateValueStrategy strategy = new UpdateValueStrategy();
                strategy.setBeforeSetValidator(validator);
                bindValue = this.dbc.bindValue(uiObservable, modelObservable, strategy, null);
            } else if (uiListObservable != null) {
                IObservableList modelListObservable = Observables.staticObservableList((List)((List)this.modelMap.get((Object)p.getName())), String.class);
                UpdateListStrategy listStrategy = new UpdateListStrategy(){

                    protected IStatus doAdd(IObservableList observableList, Object element, int index) {
                        super.doAdd(observableList, element, index);
                        return this.validateMandatoryBehavior(prop, observableList);
                    }

                    protected IStatus doRemove(IObservableList observableList, int index) {
                        super.doRemove(observableList, index);
                        return this.validateMandatoryBehavior(prop, observableList);
                    }

                    private IStatus validateMandatoryBehavior(Parameter prop2, IObservableList observableList) {
                        if (prop2.getRequired() != null && "true".equalsIgnoreCase(prop2.getRequired()) && observableList.isEmpty()) {
                            return ValidationStatus.error((String)("Parameter " + prop2.getName() + " is a mandatory field and cannot be empty."));
                        }
                        return ValidationStatus.ok();
                    }
                };
                bindValue = this.dbc.bindList(uiListObservable, modelListObservable, listStrategy, null);
            }
            if (bindValue != null) {
                ControlDecorationSupport.create(bindValue, (int)16512);
            }
            if (c == null) continue;
            this.createHelpDecoration(p, (Control)c);
        }
        page.layout();
    }

    protected void deactivateMouseWheel(CCombo choiceCombo) {
        choiceCombo.addListener(37, event -> {
            boolean bl = event.doit = false;
        });
        choiceCombo.addListener(37, event -> {
            boolean bl = event.doit = false;
        });
    }

    boolean shouldHidePropertyFromGroup(String group, Parameter p, String currentPropertyGroup) {
        return this.isNotMatchingGroup(group, currentPropertyGroup) || this.isInternalElementToHide(p) || this.isClassParamToHide(p);
    }

    private boolean isNotMatchingGroup(String group, String currentPropertyGroup) {
        if ("General".equals(group)) {
            return currentPropertyGroup != null && !currentPropertyGroup.trim().isEmpty();
        }
        return !group.equals(currentPropertyGroup);
    }

    private boolean isClassParamToHide(Parameter p) {
        return CamelComponentUtils.isClassProperty((Parameter)p) && "element".equalsIgnoreCase(p.getKind()) && !CamelComponentUtils.isDataFormatProperty((Parameter)p) && !CamelComponentUtils.isDescriptionProperty((Parameter)p);
    }

    private boolean isInternalElementToHide(Parameter p) {
        return "element".equalsIgnoreCase(p.getKind()) && "array".equalsIgnoreCase(p.getType()) && !"exception".equalsIgnoreCase(p.getName()) || "org.apache.camel.model.OtherwiseDefinition".equals(p.getJavaType());
    }
}

