/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.net.URL;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.properties.NodeSectionSupport;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.ui.util.Widgets;

public class DocumentationSection
extends NodeSectionSupport {
    private FormToolkit toolkit;
    private Form form;
    private Browser browser;

    @Override
    protected void onNodeChanged(AbstractCamelModelElement node) {
        this.node = node;
        if (!this.form.isDisposed()) {
            this.form.setText(node != null ? String.format("%s - %s", UIMessages.propertiesDocumentationTitle, node.getNodeTypeId()) : UIMessages.propertiesDocumentationTitle);
            this.showDocumentationPage();
        }
    }

    @Override
    public void aboutToBeShown() {
        this.showDocumentationPage();
        super.aboutToBeShown();
    }

    protected void showDocumentationPage() {
        if (this.node != null) {
            int idx;
            String uri;
            boolean loadedPage = false;
            if ((this.node.getNodeTypeId().equalsIgnoreCase("from") || this.node.getNodeTypeId().equalsIgnoreCase("to")) && (uri = (String)this.node.getParameter("uri")) != null && (idx = uri.indexOf(58)) > 0) {
                String scheme = uri.substring(0, idx);
                String contextId = "org.fusesource.ide.camel.editor." + scheme;
                loadedPage = this.resolvePage(contextId, true);
                if (CamelEditorUIActivator.getDefault().isDebugging()) {
                    CamelEditorUIActivator.pluginLog().logInfo("Loaded page " + contextId + " " + loadedPage);
                }
            }
            if (!loadedPage) {
                String text = this.node.getDocumentationFileName();
                String uri2 = "org.fusesource.ide.camel.editor.allEIPs";
                if (text != null) {
                    uri2 = "org.fusesource.ide.camel.editor." + text;
                }
                this.resolvePage(uri2, false);
            }
        }
    }

    protected boolean resolvePage(String contextId, boolean endpoint) {
        IHelpResource resource;
        String contextName = contextId;
        IContext context = HelpSystem.getContext((String)contextName);
        if (context == null) {
            contextName = endpoint ? "org.fusesource.ide.camel.editor.endpoint" : "org.fusesource.ide.camel.editor.allEIPs";
            context = HelpSystem.getContext((String)contextName);
        }
        if (context == null) {
            CamelEditorUIActivator.pluginLog().logWarning("Could not find context: " + contextName);
            return false;
        }
        IHelpResource[] relatedTopics = context.getRelatedTopics();
        if (relatedTopics != null && relatedTopics.length > 0 && (resource = relatedTopics[0]) != null) {
            String helpUrl = resource.getHref();
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            URL url = helpSystem.resolve(helpUrl, true);
            return this.browser.setUrl(url.toExternalForm());
        }
        CamelEditorUIActivator.pluginLog().logWarning("Could not find resource in context: " + contextName);
        return false;
    }

    public void refresh() {
    }

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        if (!Widgets.isDisposed((Control)this.form)) {
            try {
                this.form.dispose();
            }
            catch (Exception exception) {}
        }
        this.form = null;
        if (parent.isDisposed()) {
            return;
        }
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setText(UIMessages.propertiesDocumentationTitle);
        this.toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        ToolBar navBar = new ToolBar(sbody, 0);
        this.toolkit.adapt((Composite)navBar);
        navBar.setLayoutData((Object)new GridData(800));
        final ToolItem back = new ToolItem(navBar, 8);
        back.setText("<");
        back.setEnabled(false);
        final ToolItem forward = new ToolItem(navBar, 8);
        forward.setText(">");
        forward.setEnabled(false);
        back.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentationSection.this.browser.back();
            }
        });
        forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DocumentationSection.this.browser.forward();
            }
        });
        LocationListener locationListener = new LocationListener(){

            public void changed(LocationEvent event) {
                Browser browser = (Browser)event.widget;
                back.setEnabled(browser.isBackEnabled());
                forward.setEnabled(browser.isForwardEnabled());
            }

            public void changing(LocationEvent event) {
            }
        };
        this.browser = new Browser(sbody, 0);
        GridData data = new GridData(1808);
        this.browser.setLayoutData((Object)data);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        URL url = helpSystem.resolve("org.fusesource.ide.help/index.html", true);
        if (url != null) {
            this.browser.setUrl(url.toExternalForm());
            this.browser.addLocationListener(locationListener);
        }
        this.form.layout(true, true);
        parent.layout(true, true);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DocumentationSection.this.form != null && !DocumentationSection.this.form.isDisposed()) {
                    DocumentationSection.this.form.layout(true, true);
                }
                if (parent != null && !parent.isDisposed()) {
                    parent.layout(true, true);
                }
            }
        });
    }
}

