/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.forms.widgets.FormsResources;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.camel.editor.properties.ParameterPriorityComparator;
import org.fusesource.ide.camel.editor.utils.MavenUtils;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.IParameterContainer;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.catalog.languages.Language;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.model.service.core.util.CamelComponentUtils;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.ControlDecorationHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class FusePropertySection
extends AbstractPropertySection {
    public static final String DEFAULT_GROUP = "General";
    public static final String GROUP_PATH = "Path";
    public static final String GROUP_COMMON = "Common";
    public static final String GROUP_CONSUMER = "Consumer";
    public static final String GROUP_PRODUCER = "Producer";
    protected FormToolkit toolkit;
    protected Form form;
    protected CTabFolder tabFolder;
    protected List<CTabItem> tabs = new ArrayList<CTabItem>();
    protected AbstractCamelModelElement selectedEP;
    protected AbstractCamelModelElement lastSelectedEP;
    protected DataBindingContext dbc;
    protected IObservableMap modelMap = new WritableMap();
    protected Composite parent;
    protected TabbedPropertySheetPage aTabbedPropertySheetPage;
    protected Component component;
    protected Eip eip;

    public void dispose() {
        if (this.form != null) {
            this.form.dispose();
        }
        this.disposeTabs();
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.aTabbedPropertySheetPage = null;
        this.component = null;
        this.eip = null;
        super.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        AbstractCamelModelElement n = NodeUtils.getSelectedNode(selection);
        if (!Objects.equals(this.lastSelectedEP, n)) {
            if (n.getUnderlyingMetaModelObject() != null) {
                this.selectedEP = n;
                this.eip = PropertiesUtils.getEipFor((AbstractCamelModelElement)this.selectedEP);
                if (this.selectedEP.isEndpointElement()) {
                    this.component = PropertiesUtils.getComponentFor((AbstractCamelModelElement)this.selectedEP);
                }
            } else {
                this.selectedEP = null;
            }
            this.initSectionFor(this.selectedEP);
        }
    }

    private void initSectionFor(AbstractCamelModelElement n) {
        this.dbc = new DataBindingContext();
        this.createTabFolder();
        if (n != null && n.getUnderlyingMetaModelObject() != null) {
            String headerText = this.selectedEP.getDisplayText();
            this.form.setText(headerText);
        } else {
            this.form.setText("");
        }
        this.lastSelectedEP = n;
        int idx = Math.max(this.tabFolder.getSelectionIndex(), 0);
        if (!this.tabs.isEmpty()) {
            for (CTabItem tab : this.tabs) {
                if (tab.isDisposed()) continue;
                tab.dispose();
            }
            this.tabs.clear();
        }
        this.createContentTabs(this.tabFolder);
        this.tabFolder.setSingle(this.tabFolder.getItemCount() == 1);
        this.tabFolder.setSelection(idx >= this.tabFolder.getItemCount() ? 0 : idx);
        this.form.redraw();
        this.form.layout();
        this.form.update();
    }

    private void disposeTabs() {
        if (!this.tabs.isEmpty()) {
            for (CTabItem tab : this.tabs) {
                if (tab.isDisposed()) continue;
                tab.dispose();
            }
            this.tabs.clear();
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.parent = parent;
        this.aTabbedPropertySheetPage = aTabbedPropertySheetPage;
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
    }

    protected void createStandardTabLayout(String sectionTitle) {
        this.parent.setLayout((Layout)new GridLayout());
        this.parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(this.parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        this.tabFolder = new CTabFolder(sbody, 0x800080);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{20}, true);
        this.tabFolder.setCursor(FormsResources.getHandCursor());
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.form.setText(sectionTitle);
        this.toolkit.decorateFormHeading(this.form);
        this.form.layout();
        this.tabFolder.setSelection(0);
    }

    private void createTabFolder() {
        if (this.form != null) {
            this.form.dispose();
        }
        this.form = this.toolkit.createForm(this.parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
        }
        this.tabFolder = new CTabFolder(this.form.getBody(), 0x800080);
        this.toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        Color selectedColor = this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, this.toolkit.getColors().getBackground()}, new int[]{20}, true);
        this.tabFolder.setCursor(FormsResources.getHandCursor());
        this.toolkit.paintBordersFor((Composite)this.tabFolder);
        this.toolkit.decorateFormHeading(this.form);
        this.form.layout();
        this.parent.layout(true);
        this.tabFolder.setSelection(0);
    }

    protected abstract void createContentTabs(CTabFolder var1);

    public void createPropertyLabel(FormToolkit toolkit, Composite page, Parameter p) {
        String s = this.computePropertyDisplayName(p);
        Label l = toolkit.createLabel(page, s);
        l.setLayoutData((Object)new GridData());
        this.addDescriptionAsTooltip(p, l);
    }

    protected Display getDisplay() {
        return Display.getDefault();
    }

    protected String computePropertyDisplayName(Parameter parameter) {
        String s = Strings.humanize((String)parameter.getName());
        if (CamelComponentUtils.isExpressionProperty((Parameter)parameter)) {
            s = "Language";
        }
        if (PropertiesUtils.isRequired((Parameter)parameter)) {
            s = String.valueOf(s) + " *";
        }
        if (PropertiesUtils.isDeprecated((Parameter)parameter)) {
            s = String.valueOf(s) + " (deprecated)";
        }
        return s;
    }

    private void addDescriptionAsTooltip(Parameter parameter, Label label) {
        String description = parameter.getDescription();
        if (description != null) {
            label.setToolTipText(description.replaceAll("&", "&&"));
        }
    }

    protected CamelModel getCamelModel(AbstractCamelModelElement modelElement) {
        CamelModel model = null;
        if (modelElement != null) {
            model = modelElement.getCamelFile().getCamelModel();
        }
        if (model == null && this.lastSelectedEP != null) {
            model = this.lastSelectedEP.getCamelFile().getCamelModel();
        }
        return model;
    }

    protected void languageChanged(String language, Composite eform, AbstractCamelModelElement expressionElement, Composite page, Parameter prop) {
        Element expNode;
        Node oldExpNode;
        IProject project = this.selectedEP.getCamelFile().getResource().getProject();
        Control[] controlArray = eform.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control co = controlArray[n2];
            if (co.getData("fuseExpressionClient") != null) {
                co.dispose();
            }
            ++n2;
        }
        Composite client = this.getWidgetFactory().createComposite(eform);
        client.setData("fuseExpressionClient", (Object)true);
        client.setLayoutData((Object)new GridData(1808));
        client.setLayout((Layout)new GridLayout(4, false));
        AbstractCamelModelElement uiExpressionElement = null;
        Language lang = this.getCamelModel(expressionElement).getLanguage(language);
        if ("expression".equalsIgnoreCase(prop.getName())) {
            if (this.selectedEP != null && expressionElement != null && !expressionElement.getTagNameWithoutPrefix().equals(language)) {
                oldExpNode = null;
                int i = 0;
                while (i < this.selectedEP.getXmlNode().getChildNodes().getLength()) {
                    if (CamelUtils.getTagNameWithoutPrefix((Node)this.selectedEP.getXmlNode().getChildNodes().item(i)).equals(expressionElement.getTagNameWithoutPrefix())) {
                        oldExpNode = this.selectedEP.getXmlNode().getChildNodes().item(i);
                        break;
                    }
                    ++i;
                }
                if (language.trim().length() > 0) {
                    Element expNode2 = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                    expressionElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode2);
                    this.selectedEP.setParameter(prop.getName(), (Object)expressionElement);
                    this.selectedEP.getXmlNode().replaceChild(expNode2, oldExpNode);
                    if (lang != null) {
                        this.updateDependencies(lang.getDependencies(), project);
                    }
                } else {
                    this.selectedEP.getXmlNode().removeChild(oldExpNode);
                    this.selectedEP.removeParameter(prop.getName());
                }
            } else if (this.selectedEP != null && expressionElement == null && language.trim().length() > 0) {
                expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                expressionElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
                this.selectedEP.getXmlNode().insertBefore(expNode, this.selectedEP.getXmlNode().getFirstChild());
                this.selectedEP.setParameter(prop.getName(), (Object)expressionElement);
                if (lang != null) {
                    this.updateDependencies(lang.getDependencies(), project);
                }
            }
            uiExpressionElement = expressionElement;
        } else if (this.selectedEP != null && expressionElement != null && expressionElement.getParameter("expression") != null) {
            oldExpNode = null;
            List<String> langs = Arrays.asList(CamelComponentUtils.getOneOfList((Parameter)prop));
            int i = 0;
            while (i < expressionElement.getXmlNode().getChildNodes().getLength()) {
                Node n3 = expressionElement.getXmlNode().getChildNodes().item(i);
                if (langs.contains(CamelUtils.getTagNameWithoutPrefix((Node)n3))) {
                    oldExpNode = n3;
                    break;
                }
                ++i;
            }
            AbstractCamelModelElement expElement = (AbstractCamelModelElement)expressionElement.getParameter("expression");
            if (!expElement.getTagNameWithoutPrefix().equals(language)) {
                if (language.trim().length() > 0) {
                    Element expNode3 = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                    uiExpressionElement = new CamelBasicModelElement(expressionElement, (Node)expNode3);
                    expressionElement.getXmlNode().replaceChild(expNode3, oldExpNode);
                    expressionElement.setParameter("expression", (Object)uiExpressionElement);
                    if (lang != null) {
                        this.updateDependencies(lang.getDependencies(), project);
                    }
                } else {
                    this.selectedEP.getXmlNode().removeChild(expressionElement.getXmlNode());
                    this.selectedEP.removeParameter(prop.getName());
                }
            } else {
                uiExpressionElement = expElement;
            }
        } else if (this.selectedEP != null && expressionElement != null && expressionElement.getParameter("expression") == null) {
            expNode = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            uiExpressionElement = new CamelBasicModelElement(expressionElement, (Node)expNode);
            expressionElement.getXmlNode().appendChild(expNode);
            expressionElement.setParameter("expression", (Object)uiExpressionElement);
        } else if (this.selectedEP != null && expressionElement == null && language.trim().length() > 0) {
            Element expContainerNode = this.selectedEP.createElement(prop.getName(), this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            Element expNode4 = this.selectedEP.createElement(language, this.selectedEP != null && this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            CamelBasicModelElement expContainerElement = new CamelBasicModelElement(this.selectedEP, (Node)expContainerNode);
            expressionElement = new CamelBasicModelElement((AbstractCamelModelElement)expContainerElement, (Node)expNode4);
            expContainerElement.getXmlNode().appendChild(expNode4);
            this.selectedEP.getXmlNode().insertBefore(expContainerNode, this.selectedEP.getXmlNode().getFirstChild());
            expContainerElement.setParameter("expression", (Object)expressionElement);
            this.selectedEP.setParameter(prop.getName(), (Object)expContainerElement);
            uiExpressionElement = expressionElement;
            if (lang != null) {
                this.updateDependencies(lang.getDependencies(), project);
            }
        }
        this.prepareExpressionUIForLanguage(language, uiExpressionElement, client);
        page.layout(true);
        this.refresh();
        eform.layout(true);
        this.aTabbedPropertySheetPage.resizeScrolledComposite();
    }

    protected void prepareExpressionUIForLanguage(String language, AbstractCamelModelElement expressionElement, Composite parent) {
        block3: {
            Language lang;
            CamelModel model;
            block2: {
                model = this.getCamelModel(expressionElement);
                lang = model.getLanguage(language);
                if (lang == null) break block2;
                List props = lang.getParameters();
                props.sort(new ParameterPriorityComparator());
                for (Parameter p : props) {
                    this.createPropertyLabel(this.toolkit, parent, p);
                    Control field = this.getControlForParameter(p, parent, expressionElement, (IParameterContainer)lang);
                    field.setToolTipText(p.getDescription());
                }
                break block3;
            }
            Eip modelEip = model.getEip(language);
            if (modelEip == null) break block3;
            List props = modelEip.getParameters();
            props.sort(new ParameterPriorityComparator());
            for (Parameter p : props) {
                this.createPropertyLabel(this.toolkit, parent, p);
                Control field = this.getControlForParameter(p, parent, expressionElement, (IParameterContainer)lang);
                field.setToolTipText(p.getDescription());
            }
        }
    }

    protected void dataFormatChanged(String dataformat, Composite eform, AbstractCamelModelElement dataFormatElement, Composite page, Parameter prop) {
        IProject project = this.selectedEP.getCamelFile().getResource().getProject();
        Control[] controlArray = eform.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control co = controlArray[n2];
            if (co.getData("fuseDataFormatClient") != null) {
                co.dispose();
            }
            ++n2;
        }
        Composite client = this.getWidgetFactory().createComposite(eform);
        client.setData("fuseDataFormatClient", (Object)true);
        client.setLayoutData((Object)new GridData(1808));
        client.setLayout((Layout)new GridLayout(4, false));
        DataFormat df = this.getCamelModel(dataFormatElement).getDataFormat(dataformat);
        if (dataFormatElement != null && df != null && !dataFormatElement.getTagNameWithoutPrefix().equals(dataformat)) {
            Node oldExpNode = null;
            int i = 0;
            while (i < this.selectedEP.getXmlNode().getChildNodes().getLength()) {
                Node childNode = this.selectedEP.getXmlNode().getChildNodes().item(i);
                if (CamelUtils.getTagNameWithoutPrefix((Node)childNode).equalsIgnoreCase(dataFormatElement.getTagNameWithoutPrefix())) {
                    oldExpNode = childNode;
                    break;
                }
                ++i;
            }
            if (dataformat.trim().length() > 0) {
                Element expNode = this.selectedEP.createElement(dataformat, this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
                dataFormatElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
                this.selectedEP.setParameter(prop.getName(), (Object)dataFormatElement);
                this.selectedEP.getXmlNode().replaceChild(expNode, oldExpNode);
                this.updateDependencies(df.getDependencies(), project);
            } else {
                this.selectedEP.getXmlNode().removeChild(oldExpNode);
                this.selectedEP.removeParameter(prop.getName());
            }
        } else if (dataFormatElement == null && dataformat.trim().length() > 0) {
            Element expNode = this.selectedEP.createElement(dataformat, this.selectedEP.getXmlNode() != null ? this.selectedEP.getXmlNode().getPrefix() : null);
            dataFormatElement = new CamelBasicModelElement(this.selectedEP, (Node)expNode);
            this.selectedEP.getXmlNode().insertBefore(expNode, this.selectedEP.getXmlNode().getFirstChild());
            this.selectedEP.setParameter(prop.getName(), (Object)dataFormatElement);
            this.updateDependencies(df.getDependencies(), project);
        }
        this.prepareDataFormatUIForDataFormat(dataformat, dataFormatElement, client);
        page.layout(true);
        this.refresh();
        eform.layout(true);
        this.aTabbedPropertySheetPage.resizeScrolledComposite();
    }

    private void updateDependencies(List<Dependency> dependencies, IProject project) {
        new MavenUtils().updateMavenDependencies(dependencies, project);
    }

    protected void updateDependenciesForDataFormat(AbstractCamelModelElement selectedEP, String newValue) {
        if (newValue != null) {
            DataFormat df;
            IProject project = selectedEP.getCamelFile().getResource().getProject();
            CamelModel m = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
            if (m != null && (df = m.getDataFormat(newValue)) != null) {
                this.updateDependencies(df.getDependencies(), project);
            }
        }
    }

    protected void updateDependenciesForLanguage(AbstractCamelModelElement selectedEP, String newValue) {
        if (newValue != null) {
            Language l;
            IProject project = selectedEP.getCamelFile().getResource().getProject();
            CamelModel m = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
            if (m != null && (l = m.getLanguage(newValue)) != null) {
                this.updateDependencies(l.getDependencies(), project);
            }
        }
    }

    protected void prepareDataFormatUIForDataFormat(String dataformat, AbstractCamelModelElement dataFormatElement, Composite parent) {
        CamelModel model = this.getCamelModel(dataFormatElement);
        Eip df = model.getEip(dataformat);
        if (df != null) {
            List props = df.getParameters();
            props.sort(new ParameterPriorityComparator());
            for (Parameter p : props) {
                this.createPropertyLabel(this.toolkit, parent, p);
                Control field = this.getControlForParameter(p, parent, dataFormatElement, (IParameterContainer)df);
                field.setToolTipText(p.getDescription());
            }
        }
    }

    protected Control getControlForParameter(final Parameter p, Composite parent, final AbstractCamelModelElement camelModelElement, IParameterContainer parameterContainer) {
        Text c;
        if (CamelComponentUtils.isChoiceProperty((Parameter)p)) {
            String initialTextValue = camelModelElement != null && camelModelElement.getParameter(p.getName()) != null ? (String)camelModelElement.getParameter(p.getName()) : (parameterContainer != null ? parameterContainer.getParameter(p.getName()).getDefaultValue() : p.getDefaultValue());
            CCombo txtField = this.getWidgetFactory().createCCombo(parent, 16396);
            txtField.setItems(CamelComponentUtils.getChoicesWithExtraEmptyEntry((Parameter)p));
            txtField.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CCombo txt = (CCombo)e.getSource();
                    camelModelElement.setParameter(p.getName(), (Object)txt.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            int idx = 0;
            while (idx < txtField.getItemCount()) {
                if (txtField.getItem(idx).equalsIgnoreCase(initialTextValue)) {
                    txtField.select(idx);
                    break;
                }
                ++idx;
            }
            c = txtField;
        } else if (CamelComponentUtils.isBooleanProperty((Parameter)p)) {
            Object paramValue;
            final Button checkBox = this.getWidgetFactory().createButton(parent, "", 32);
            Boolean b = camelModelElement != null && camelModelElement.getParameter(p.getName()) != null ? ((paramValue = camelModelElement.getParameter(p.getName())) instanceof String ? Boolean.valueOf((String)paramValue) : (Boolean)paramValue) : (parameterContainer != null ? Boolean.valueOf(Boolean.parseBoolean(parameterContainer.getParameter(p.getName()).getDefaultValue())) : Boolean.valueOf(Boolean.parseBoolean(p.getDefaultValue())));
            checkBox.setSelection(b.booleanValue());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    camelModelElement.setParameter(p.getName(), (Object)checkBox.getSelection());
                }
            });
            checkBox.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = checkBox;
        } else if (CamelComponentUtils.isTextProperty((Parameter)p)) {
            String initialTextValue = camelModelElement != null && camelModelElement.getParameter(p.getName()) != null ? (String)camelModelElement.getParameter(p.getName()) : (parameterContainer != null ? parameterContainer.getParameter(p.getName()).getDefaultValue() : p.getDefaultValue());
            Text txtField = this.getWidgetFactory().createText(parent, initialTextValue, 16388);
            txtField.addModifyListener(e -> {
                Text txt = (Text)e.getSource();
                camelModelElement.setParameter(p.getName(), (Object)txt.getText());
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        } else if (CamelComponentUtils.isNumberProperty((Parameter)p)) {
            String initialValue = camelModelElement != null && camelModelElement.getParameter(p.getName()) != null ? (String)camelModelElement.getParameter(p.getName()) : (parameterContainer != null ? parameterContainer.getParameter(p.getName()).getDefaultValue() : p.getDefaultValue());
            Text txtField = this.getWidgetFactory().createText(parent, initialValue, 131076);
            txtField.addModifyListener(e -> {
                Text txt = (Text)e.getSource();
                String val = txt.getText();
                try {
                    Double.parseDouble(val);
                    txt.setBackground(ColorConstants.white);
                    camelModelElement.setParameter(p.getName(), (Object)txt.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    txt.setBackground(ColorConstants.red);
                    return;
                }
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        } else if (camelModelElement != null && camelModelElement.getParameter(p.getName()) instanceof List) {
            List initialValue = (List)camelModelElement.getParameter(p.getName());
            String delimiter = ",";
            String collect = initialValue.stream().collect(Collectors.joining(delimiter));
            Text txtField = this.getWidgetFactory().createText(parent, collect, 16388);
            txtField.addModifyListener(e -> {
                Text txt = (Text)e.getSource();
                camelModelElement.setParameter(p.getName(), Arrays.asList(txt.getText().split(delimiter)));
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        } else {
            String initialValue = camelModelElement != null && camelModelElement.getParameter(p.getName()) != null ? (String)camelModelElement.getParameter(p.getName()) : (parameterContainer != null ? parameterContainer.getParameter(p.getName()).getDefaultValue() : p.getDefaultValue());
            Text txtField = this.getWidgetFactory().createText(parent, initialValue, 16388);
            txtField.addModifyListener(e -> {
                Text txt = (Text)e.getSource();
                camelModelElement.setParameter(p.getName(), (Object)txt.getText());
            });
            txtField.setLayoutData((Object)this.createPropertyFieldLayoutData());
            c = txtField;
        }
        return c;
    }

    protected void createHelpDecoration(Parameter parameter, Control control) {
        String description = parameter.getDescription();
        if (description != null) {
            new ControlDecorationHelper().addInformationOnFocus(control, description);
        }
    }

    protected GridData createPropertyFieldLayoutData() {
        return GridDataFactory.fillDefaults().indent(5, 0).span(3, 1).grab(true, false).create();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.initSectionFor(this.selectedEP);
    }
}

