/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.utils.NodeSelectionSupport;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public abstract class NodeSectionSupport
extends AbstractPropertySection {
    protected AbstractCamelModelElement node;
    private WorkbenchPart lastPart;
    private NodeSelectionSupport nodeListener = new NodeSelectionSupport(){

        @Override
        protected void onNodeChanged(AbstractCamelModelElement node) {
            super.onNodeChanged(node);
            NodeSectionSupport.this.setSelectedNode(node);
        }
    };
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            NodeSectionSupport.this.nodeListener.selectionChanged((IWorkbenchPart)NodeSectionSupport.this.lastPart, event.getSelection());
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        WorkbenchPart workbenchPart;
        if (part instanceof WorkbenchPart && this.lastPart != (workbenchPart = (WorkbenchPart)part)) {
            this.lastPart = workbenchPart;
            ISelectionProvider selectionProvider = workbenchPart.getSite().getSelectionProvider();
            try {
                selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
            }
            catch (Exception exception) {}
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
        }
        super.setInput(part, selection);
        AbstractCamelModelElement newNode = this.getSelectedNode(selection);
        this.setSelectedNode(newNode);
    }

    protected AbstractCamelModelElement getSelectedNode(ISelection selection) {
        return NodeUtils.getSelectedNode(selection);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        ISelection selection = null;
        AbstractCamelModelElement newNode = null;
        if (this.lastPart != null && (newNode = this.getSelectedNode(selection = this.lastPart.getSite().getSelectionProvider().getSelection())) != null) {
            this.setSelectedNode(newNode);
        }
        if (CamelEditorUIActivator.getDefault().isDebugging()) {
            CamelEditorUIActivator.pluginLog().logInfo("After " + (Object)((Object)this) + " about to be shown selection " + selection + " node: " + newNode + " last part: " + this.lastPart);
        }
    }

    protected void setSelectedNode(AbstractCamelModelElement newNode) {
        if (newNode != null) {
            this.node = newNode;
            this.onNodeChanged(this.node);
        }
    }

    protected abstract void onNodeChanged(AbstractCamelModelElement var1);

    public AbstractCamelModelElement getNode() {
        return this.node;
    }

    public AbstractCamelModelElement getNodeContainer() {
        if (this.node != null) {
            return this.node.getParent();
        }
        return null;
    }
}

