/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties.bean;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fusesource.ide.camel.editor.properties.bean.PropertyRequiredValidator;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.validation.model.RefOrDataFormatUnicityChoiceValidator;

public class PropertyRefValidator
extends PropertyRequiredValidator {
    private AbstractCamelModelElement parent;
    private Parameter prop;

    public PropertyRefValidator(Parameter prop, AbstractCamelModelElement parent) {
        super(prop);
        this.parent = parent;
        this.prop = prop;
    }

    @Override
    public IStatus validate(Object value) {
        IStatus superStatus = super.validate(value);
        if (Status.OK_STATUS.equals(superStatus)) {
            if (this.isNotEmptyString(value) && this.parent.getRouteContainer().findNode((String)value) == null && !this.parent.getCamelFile().getGlobalDefinitions().containsKey((String)value)) {
                return ValidationStatus.warning((String)("Parameter " + this.prop.getName() + " does not point to an existing reference inside the context."));
            }
            return new RefOrDataFormatUnicityChoiceValidator(this.parent, this.prop).validate(value);
        }
        return superStatus;
    }

    private boolean isNotEmptyString(Object value) {
        return value != null && value instanceof String && value.toString().trim().length() > 0;
    }
}

