/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.fusesource.ide.camel.editor.provider.ext.IDependenciesManager;
import org.fusesource.ide.foundation.core.util.Strings;

public class ActiveMQPaletteEntryDependenciesManager
implements IDependenciesManager {
    public static final String RED_HAT_SUFFIX = ".redhat-";
    private static final String FUSE_SUFFIX = ".fuse-";
    static final String ORG_APACHE_ACTIVEMQ = "org.apache.activemq";
    public static final String ACTIVEMQ_CAMEL = "activemq-camel";
    public static final String ACTIVEMQ_CAMEL_STARTER = "activemq-camel-starter";
    public static final String LATEST_AMQ_VERSION = "5.11.0";
    public static final Map<String, String> CAMEL_TO_AMQ_VERSION_MAPPING = new HashMap<String, String>();

    static {
        CAMEL_TO_AMQ_VERSION_MAPPING.put("2.15.1", LATEST_AMQ_VERSION);
        CAMEL_TO_AMQ_VERSION_MAPPING.put("2.17.0", LATEST_AMQ_VERSION);
        CAMEL_TO_AMQ_VERSION_MAPPING.put("2.17.3", LATEST_AMQ_VERSION);
        CAMEL_TO_AMQ_VERSION_MAPPING.put("2.18.1", LATEST_AMQ_VERSION);
    }

    @Override
    public void updatePluginDependencies(List<Plugin> currentPlugins, String camelVersion) {
    }

    @Override
    public void updateDependencies(List<Dependency> currentDependencies, String camelVersion) {
        for (Dependency dependency : currentDependencies) {
            if (!this.isActiveMQCamelDependency(dependency)) continue;
            dependency.setVersion(this.getActiveMQVersion(camelVersion));
            return;
        }
    }

    private boolean isActiveMQCamelDependency(Dependency dependency) {
        String artifactId = dependency.getArtifactId();
        return ORG_APACHE_ACTIVEMQ.equals(dependency.getGroupId()) && (ACTIVEMQ_CAMEL.equals(artifactId) || ACTIVEMQ_CAMEL_STARTER.equals(artifactId));
    }

    String getActiveMQVersion(String camelVersion) {
        if (camelVersion != null) {
            boolean redhatProductizedVersion = camelVersion.indexOf(RED_HAT_SUFFIX) != -1;
            boolean fuseProductizedVersion = camelVersion.indexOf(FUSE_SUFFIX) != -1;
            String key = this.getVersionWithoutIdentifier(camelVersion);
            String amqVersion = CAMEL_TO_AMQ_VERSION_MAPPING.get(key);
            if (amqVersion != null) {
                if (redhatProductizedVersion) {
                    return String.format("%s%s%s", amqVersion, RED_HAT_SUFFIX, this.getBuildNumberFromVersion(camelVersion));
                }
                if (fuseProductizedVersion) {
                    return String.format("%s%s%s", amqVersion, FUSE_SUFFIX, this.getBuildNumberFromVersion(camelVersion));
                }
                return amqVersion;
            }
        }
        return LATEST_AMQ_VERSION;
    }

    String getBuildNumberFromVersion(String camelVersion) {
        if (camelVersion.split("\\.").length > 3) {
            return camelVersion.substring(camelVersion.lastIndexOf(45) + 1);
        }
        throw new IllegalArgumentException("Camel version " + camelVersion + " has no valid format for retrieving the build number.");
    }

    String getVersionWithoutIdentifier(String camelVersion) {
        String[] versionParts;
        if (!Strings.isEmpty((String)camelVersion) && (versionParts = camelVersion.split("\\.")).length > 2) {
            return String.format("%s.%s.%s", versionParts[0], versionParts[1], versionParts[2]);
        }
        throw new IllegalArgumentException("Given Camel Version " + camelVersion + " doesn't contain a valid value");
    }

    public String getArtifactId(String runtimeProvider) {
        if ("springboot".equals(runtimeProvider)) {
            return ACTIVEMQ_CAMEL_STARTER;
        }
        return ACTIVEMQ_CAMEL;
    }
}

