/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.provider.ProviderHelper;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.osgi.framework.Bundle;

public class ImageProvider
extends AbstractImageProvider {
    private static final String PATTERN_FOR_IMAGE_NAME = "%s%s%s";
    private static final String ROOT_FOLDER_FOR_IMG = "icons/";
    public static final String PREFIX = "org.fusesource.ide.icons.";
    public static final String POSTFIX_SMALL = "_small";
    public static final String POSTFIX_LARGE = "_diagram";
    public static final String IMG_FLOW = "org.fusesource.ide.icons.flow";
    public static final String IMG_REDDOT = "org.fusesource.ide.icons.reddot";
    public static final String IMG_GREENDOT = "org.fusesource.ide.icons.greendot";
    public static final String IMG_GRAYDOT = "org.fusesource.ide.icons.graydot";
    public static final String IMG_YELLOWDOT = "org.fusesource.ide.icons.yellowdot";
    public static final String IMG_DELETE_BP = "org.fusesource.ide.icons.delete_bp";
    public static final String IMG_PROPERTIES_BP = "org.fusesource.ide.icons.properties_bp";
    public static final String IMG_UP_NAV = "org.fusesource.ide.icons.up_nav";
    public static final String IMG_OUTLINE_TREE = "org.fusesource.ide.icons.outline.tree";
    public static final String IMG_OUTLINE_THUMBNAIL = "org.fusesource.ide.icons.outline.thumbnail";
    private static List<String> externalImages = new ArrayList<String>();

    protected void addAvailableImages() {
        this.addImage(IMG_REDDOT, "icons/red-dot.png");
        this.addToImageRegistry(IMG_REDDOT, "icons/red-dot.png");
        this.addImage(IMG_GRAYDOT, "icons/gray-dot.png");
        this.addToImageRegistry(IMG_GRAYDOT, "icons/gray-dot.png");
        this.addImage(IMG_GREENDOT, "icons/green-dot.png");
        this.addToImageRegistry(IMG_GREENDOT, "icons/green-dot.png");
        this.addImage(IMG_YELLOWDOT, "icons/yellow-dot.png");
        this.addToImageRegistry(IMG_YELLOWDOT, "icons/yellow-dot.png");
        this.addImage(IMG_DELETE_BP, "icons/delete_bp.png");
        this.addToImageRegistry(IMG_DELETE_BP, "icons/delete_bp.png");
        this.addImage(IMG_PROPERTIES_BP, "icons/properties_bp.png");
        this.addToImageRegistry(IMG_PROPERTIES_BP, "icons/properties_bp.png");
        this.addImage(IMG_FLOW, "icons/flow16.png");
        this.addToImageRegistry(IMG_FLOW, "icons/flow16.png");
        this.addImage(IMG_OUTLINE_THUMBNAIL, "icons/thumbnail.png");
        this.addToImageRegistry(IMG_OUTLINE_THUMBNAIL, "icons/thumbnail.png");
        this.addImage(IMG_OUTLINE_TREE, "icons/tree.png");
        this.addToImageRegistry(IMG_OUTLINE_TREE, "icons/tree.png");
        this.addImage(IMG_UP_NAV, "icons/up_nav.gif");
        this.addToImageRegistry(IMG_UP_NAV, "icons/up_nav.gif");
        this.addExtensionPointImages();
        ProviderHelper.addFigureIcons(this);
        this.addIconsForClass((AbstractCamelModelElement)new CamelRouteElement(null, null), "route16.png", "route.png");
        String prefix = "/icons/";
        Enumeration enu = CamelEditorUIActivator.getDefault().getBundle().findEntries(prefix, "*", true);
        while (enu.hasMoreElements()) {
            String file;
            URL u = (URL)enu.nextElement();
            String fileName = file = u.getFile();
            if (!file.startsWith(prefix)) {
                CamelEditorUIActivator.pluginLog().logWarning("Warning: image: " + fileName + " does not start with prefix: " + prefix);
            }
            this.addIconCustomImage(fileName);
        }
    }

    private void addExtensionPointImages() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.fusesource.ide.editor.paletteContributor");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Bundle b = this.getBundleById(e.getContributor().getName());
            if (b == null) {
                return;
            }
            String entryId = e.getAttribute("id");
            String paletteIconPath = e.getAttribute("paletteIcon");
            String diagramImagePath = e.getAttribute("diagramImage");
            if (paletteIconPath != null && paletteIconPath.trim().length() > 0) {
                this.cacheImage(b, entryId, paletteIconPath, POSTFIX_SMALL);
            }
            if (diagramImagePath != null && diagramImagePath.trim().length() > 0) {
                this.cacheImage(b, entryId, diagramImagePath, POSTFIX_LARGE);
            }
            ++n2;
        }
    }

    private void cacheImage(Bundle b, String entryId, String iconPath, String postfix) {
        String key = String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, entryId, postfix);
        URL imgUrl = b.getEntry(iconPath);
        String fileExt = imgUrl.getFile().substring(imgUrl.getFile().lastIndexOf(46));
        this.addImageFilePath(key, imgUrl.toString());
        CamelEditorUIActivator.getDefault().getImageRegistry().put(key, this.getExternalImage(b, iconPath));
        externalImages.add(String.valueOf(entryId) + fileExt);
    }

    private Bundle getBundleById(String id) {
        Bundle[] bundleArray = CamelEditorUIActivator.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals(id)) {
                return b;
            }
            ++n2;
        }
        return null;
    }

    private ImageDescriptor getExternalImage(Bundle bundle, String iconPath) {
        URL url = bundle.getResource(iconPath);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    private void addIconCustomImage(String iconPath) {
        if (iconPath == null || iconPath.endsWith("/")) {
            return;
        }
        String iconName = iconPath.substring(iconPath.lastIndexOf(47) + 1, iconPath.lastIndexOf(46));
        if (iconName.endsWith("16")) {
            iconName = iconName.substring(0, iconName.lastIndexOf("16"));
        }
        String key = String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, iconPath.toLowerCase().endsWith("16.png") ? POSTFIX_SMALL : POSTFIX_LARGE);
        this.addImage(key, iconPath);
        this.addToImageRegistry(key, iconPath);
    }

    public void addIconsForClass(AbstractCamelModelElement node, String fileNameSmall, String fileNameLarge) {
        this.addIconsForIconName(node.getIconName(), fileNameSmall, fileNameLarge);
    }

    protected void addIconsForIconName(String iconName, String fileNameSmall, String fileNameLarge) {
        this.addImage(String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, POSTFIX_SMALL), fileNameSmall);
        this.addImage(String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, POSTFIX_LARGE), fileNameLarge);
        this.addToImageRegistry(String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, POSTFIX_SMALL), fileNameSmall);
        this.addToImageRegistry(String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, POSTFIX_LARGE), fileNameLarge);
    }

    private void addImage(String key, String value) {
        if (this.getImageFilePath(key) == null) {
            this.addImageFilePath(key, value);
        }
    }

    private void addToImageRegistry(String key, String path) {
        CamelEditorUIActivator.getDefault().getImageRegistry().put(key, CamelEditorUIActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.camel.editor", (String)path));
    }

    public void addIconsForClass(AbstractCamelModelElement node) {
        this.addIconsForClass(node, String.format("%s%s16.png", ROOT_FOLDER_FOR_IMG, node.getIconName()), String.format("%s%s.png", ROOT_FOLDER_FOR_IMG, node.getIconName()));
    }

    public void addIconsForEIP(Eip eip) {
        String eipName = eip.getName();
        this.addIconsForIconName(eipName, ROOT_FOLDER_FOR_IMG + eipName + "16.png", ROOT_FOLDER_FOR_IMG + eipName + ".png");
    }

    public static String getKeyForSmallIcon(boolean isEndpoint, String iconName) {
        return ImageProvider.getKeyForIcon(isEndpoint, iconName, "%s16.png", POSTFIX_SMALL);
    }

    public static String getKeyForDiagramIcon(boolean isEndpoint, String iconName) {
        return ImageProvider.getKeyForIcon(isEndpoint, iconName, "%s.png", POSTFIX_LARGE);
    }

    private static String getKeyForIcon(boolean isEndpoint, String iconName, String iconNamePattern, String postfix) {
        if (ImageProvider.isImageAvailable(String.format(iconNamePattern, iconName))) {
            return String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, iconName, postfix);
        }
        return String.format(PATTERN_FOR_IMAGE_NAME, PREFIX, isEndpoint ? "endpoint" : "generic", postfix);
    }

    protected static boolean isImageAvailable(String iconName) {
        if (externalImages.contains(iconName)) {
            return true;
        }
        return CamelEditorUIActivator.getDefault().getBundle().getEntry(String.format("%s%s", ROOT_FOLDER_FOR_IMG, iconName)) != null;
    }
}

