/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.ui.IEditorPart;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;

public class CamelUtils {
    public static final String CAMEL_EDITOR_ID = "org.fusesource.ide.camel.editor";

    public static String getCurrentProjectCamelVersion() {
        return CamelUtils.getCurrentProjectCamelVersion(null);
    }

    public static String getCurrentProjectCamelVersion(CamelDesignEditor editor) {
        if (editor == null) {
            editor = CamelUtils.getDiagramEditor();
        }
        return editor == null ? CamelCatalogUtils.getLatestCamelVersion() : new CamelMavenUtils().getCamelVersionFromMaven(editor.getWorkspaceProject());
    }

    public static CamelDesignEditor getDiagramEditor() {
        IEditorPart ep = org.fusesource.ide.foundation.core.util.CamelUtils.getDiagramEditor();
        return ep instanceof CamelEditor ? ((CamelEditor)ep).getDesignEditor() : null;
    }

    public static CamelDesignEditor getDiagramEditor(IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider != null && diagramTypeProvider.getDiagramBehavior() != null && diagramTypeProvider.getDiagramBehavior().getDiagramContainer() instanceof CamelDesignEditor) {
            return (CamelDesignEditor)diagramTypeProvider.getDiagramBehavior().getDiagramContainer();
        }
        return null;
    }

    public static String getRuntimeProvider(IFeatureProvider fp) {
        CamelDesignEditor diagramEditor = CamelUtils.getDiagramEditor(fp.getDiagramTypeProvider());
        return CamelCatalogUtils.getRuntimeprovider((IProject)(diagramEditor != null ? diagramEditor.getWorkspaceProject() : CamelUtils.project()), (IProgressMonitor)new NullProgressMonitor());
    }

    public static IProject project() {
        CamelDesignEditor editor = CamelUtils.getDiagramEditor();
        return editor == null ? null : editor.getWorkspaceProject();
    }

    public static IProject project(IFeatureProvider fp) {
        CamelDesignEditor editor = CamelUtils.getDiagramEditor(fp.getDiagramTypeProvider());
        return editor == null ? null : editor.getWorkspaceProject();
    }
}

