/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.graphics.Rectangle;
import org.fusesource.ide.camel.editor.provider.ImageProvider;
import org.fusesource.ide.camel.editor.utils.ImageUtils;
import org.fusesource.ide.camel.editor.utils.StyleUtil;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;

public class FigureUIFactory {
    public static final int DEFAULT_LABEL_OFFSET_H = 5;
    public static final int DEFAULT_LABEL_OFFSET_V = 5;
    public static final int FONT_SPACING_V = 4;
    public static final int IMAGE_DEFAULT_WIDTH = 32;
    public static final int IMAGE_DEFAULT_HEIGHT = 34;
    public static final int FIGURE_MAX_WIDTH = 200;
    public static final int BREAKPOINT_DECORATOR_SPACE = 25;
    public static final int CORNER_WIDTH = 15;
    public static final int CORNER_HEIGHT = 15;
    public static final int BORDER_SIZE = 1;

    private FigureUIFactory() {
    }

    public static void createFigureUI(IAddContext context, IFeatureProvider fp, ContainerShape containerShape, AbstractCamelModelElement element, Diagram diagram, String defaultLabel) {
        if (element instanceof CamelRouteElement) {
            FigureUIFactory.paintRouteFigure(context, fp, containerShape, element, diagram, defaultLabel);
        } else if (!element.getUnderlyingMetaModelObject().canHaveChildren()) {
            FigureUIFactory.paintChildFigure(context, fp, containerShape, element, diagram, defaultLabel);
        } else if (element.getUnderlyingMetaModelObject().canHaveChildren()) {
            FigureUIFactory.paintContainerFigure(context, fp, containerShape, element, diagram, defaultLabel);
        } else {
            FigureUIFactory.paintDefaultFigure(context, fp, containerShape, element, diagram, defaultLabel);
        }
    }

    private static void paintDefaultFigure(IAddContext context, IFeatureProvider fp, ContainerShape containerShape, AbstractCamelModelElement element, Diagram diagram, String defaultLabel) {
        FigureUIFactory.paintChildFigure(context, fp, containerShape, element, diagram, defaultLabel);
    }

    private static void paintContainerFigure(IAddContext context, IFeatureProvider fp, ContainerShape containerShape, AbstractCamelModelElement element, Diagram diagram, String defaultLabel) {
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        Font f = StyleUtil.getStyleForCamelText(diagram).getFont();
        IDimension fontDimension = GraphitiUi.getUiLayoutService().calculateTextSize(defaultLabel, f);
        int labelWidth = fontDimension.getWidth();
        int labelHeight = fontDimension.getHeight() + 4;
        Dimension imageDimension = ImageUtils.getImageSize(ImageProvider.getKeyForDiagramIcon(element.isEndpointElement(), element.getIconName()));
        int imageWidth = imageDimension.width;
        int imageHeight = imageDimension.height;
        Rectangle baseRect = new Rectangle(context.getX(), context.getY(), 202, 73);
        Rectangle contentSection = new Rectangle(1, 33, 199, baseRect.height - 34 - 1);
        IGaService gaService = Graphiti.getGaService();
        Color titleSectionColor = gaService.manageColor(diagram, StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        Color contentSectionColor = gaService.manageColor(diagram, StyleUtil.CONTAINER_FIGURE_BACKGROUND_COLOR);
        RoundedRectangle baseFigure = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 15, 15);
        gaService.setLocationAndSize((GraphicsAlgorithm)baseFigure, baseRect.x, baseRect.y, baseRect.width, baseRect.height);
        baseFigure.setBackground(titleSectionColor);
        baseFigure.setFilled(Boolean.valueOf(true));
        FigureUIFactory.markFigureHeaderArea((GraphicsAlgorithm)baseFigure, 34);
        containerShape.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(true));
        containerShape.getGraphicsAlgorithm().setForeground(titleSectionColor);
        containerShape.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(1));
        Image image = gaService.createImage((GraphicsAlgorithmContainer)baseFigure, ImageProvider.getKeyForDiagramIcon(element.isEndpointElement(), element.getIconName()));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, 15, (34 - imageHeight) / 2, imageWidth, imageHeight);
        Text text = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)baseFigure, defaultLabel);
        Style style = StyleUtil.getStyleForCamelText(diagram);
        text.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseFigure);
        text.setStyle(style);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(style.getFont());
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 20 + imageWidth, (34 - labelHeight) / 2, Math.min(labelWidth, baseRect.width - imageWidth - 30), labelHeight);
        FigureUIFactory.markFigureTitleArea((GraphicsAlgorithm)text, imageWidth);
        RoundedRectangle contentRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)baseFigure, 15, 15);
        contentRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseFigure);
        contentRectangle.setStyle(StyleUtil.getStyleForCamelClass(diagram));
        contentRectangle.setBackground(contentSectionColor);
        contentRectangle.setLineWidth(Integer.valueOf(1));
        contentRectangle.setLineVisible(Boolean.valueOf(false));
        contentRectangle.setFilled(Boolean.valueOf(true));
        gaService.setLocationAndSize((GraphicsAlgorithm)contentRectangle, contentSection.x, contentSection.y, contentSection.width, contentSection.height);
        FigureUIFactory.markExpandableFigureArea((GraphicsAlgorithm)contentRectangle, 34);
        IDirectEditingInfo directEditingInfo = fp.getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        ChopboxAnchor ca = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        fp.link((PictogramElement)ca, (Object)element);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedWidth", Integer.toString(containerShape.getGraphicsAlgorithm().getWidth()));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedHeight", Integer.toString(34));
    }

    private static void paintRouteFigure(IAddContext context, IFeatureProvider fp, ContainerShape containerShape, AbstractCamelModelElement element, Diagram diagram, String defaultLabel) {
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        Font f = StyleUtil.getStyleForCamelText(diagram).getFont();
        IDimension fontDimension = GraphitiUi.getUiLayoutService().calculateTextSize(defaultLabel, f);
        int labelHeight = fontDimension.getHeight() + 4;
        Rectangle baseRect = new Rectangle(context.getX(), context.getY(), 200, 34 + labelHeight + 5);
        IGaService gaService = Graphiti.getGaService();
        Color figureBackgroundColor = gaService.manageColor(diagram, StyleUtil.CONTAINER_FIGURE_BACKGROUND_COLOR);
        Color figureBorderColor = gaService.manageColor(diagram, StyleUtil.CONTAINER_FIGURE_BORDER_COLOR);
        RoundedRectangle baseFigure = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 15, 15);
        gaService.setLocationAndSize((GraphicsAlgorithm)baseFigure, baseRect.x, baseRect.y, baseRect.width, baseRect.height);
        baseFigure.setBackground(figureBackgroundColor);
        baseFigure.setFilled(Boolean.valueOf(true));
        FigureUIFactory.markFigureHeaderArea((GraphicsAlgorithm)baseFigure, 34);
        containerShape.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(true));
        containerShape.getGraphicsAlgorithm().setForeground(figureBorderColor);
        containerShape.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(1));
        Text text = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)baseFigure, defaultLabel);
        Style style = StyleUtil.getStyleForCamelText(diagram);
        text.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseFigure);
        text.setStyle(style);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(style.getFont());
        text.setForeground(GraphitiUi.getGaService().manageColor(diagram, StyleUtil.CONTAINER_FIGURE_TEXT_COLOR));
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 15, (34 - labelHeight) / 2, baseRect.width - 5 - 5, labelHeight);
        FigureUIFactory.markFigureTitleArea((GraphicsAlgorithm)text, 24);
        IDirectEditingInfo directEditingInfo = fp.getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        ChopboxAnchor ca = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        fp.link((PictogramElement)ca, (Object)element);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedWidth", Integer.toString(containerShape.getGraphicsAlgorithm().getWidth()));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedHeight", Integer.toString(34));
    }

    private static void paintChildFigure(IAddContext context, IFeatureProvider fp, ContainerShape containerShape, AbstractCamelModelElement element, Diagram diagram, String defaultLabel) {
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        Dimension imageDimension = ImageUtils.getImageSize(ImageProvider.getKeyForDiagramIcon(element.isEndpointElement(), element.getIconName()));
        int imageWidth = imageDimension.width;
        int imageHeight = imageDimension.height;
        Font f = StyleUtil.getStyleForCamelText(diagram).getFont();
        IDimension fontDimension = GraphitiUi.getUiLayoutService().calculateTextSize(defaultLabel, f);
        int labelWidth = fontDimension.getWidth();
        int labelHeight = fontDimension.getHeight() + 4;
        Rectangle baseRect = new Rectangle(context.getX(), context.getY(), Math.min(60 + imageWidth + labelWidth, 200), 34);
        IGaService gaService = Graphiti.getGaService();
        Color figureBackgroundColor = FigureUIFactory.computeBackGroundColor(element, diagram, gaService);
        RoundedRectangle baseFigure = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 15, 15);
        gaService.setLocationAndSize((GraphicsAlgorithm)baseFigure, baseRect.x, baseRect.y, baseRect.width, baseRect.height);
        baseFigure.setBackground(figureBackgroundColor);
        baseFigure.setFilled(Boolean.valueOf(true));
        containerShape.getGraphicsAlgorithm().setLineVisible(Boolean.valueOf(false));
        containerShape.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(1));
        Image image = gaService.createImage((GraphicsAlgorithmContainer)baseFigure, ImageProvider.getKeyForDiagramIcon(element.isEndpointElement(), element.getIconName()));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, 15, (baseRect.height - imageHeight) / 2, imageWidth, imageHeight);
        Text text = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)baseFigure, defaultLabel);
        Style style = StyleUtil.getStyleForCamelText(diagram);
        text.setParentGraphicsAlgorithm((GraphicsAlgorithm)baseFigure);
        text.setStyle(style);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(style.getFont());
        text.setForeground(GraphitiUi.getGaService().manageColor(diagram, StyleUtil.CONTAINER_FIGURE_TEXT_COLOR));
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 20 + imageWidth, (baseRect.height - labelHeight) / 2, Math.min(labelWidth, baseRect.width - imageWidth - 30), labelHeight);
        FigureUIFactory.markFigureTitleArea((GraphicsAlgorithm)text, imageWidth);
        IDirectEditingInfo directEditingInfo = fp.getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        ChopboxAnchor ca = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        fp.link((PictogramElement)ca, (Object)element);
    }

    public static Color computeBackGroundColor(AbstractCamelModelElement element, Diagram diagram, IGaService gaService) {
        Color figureBackgroundColor = element.isEndpointElement() ? (element.getNodeTypeId().equalsIgnoreCase("from") ? gaService.manageColor(diagram, StyleUtil.FROM_FIGURE_BACKGROUND_COLOR) : gaService.manageColor(diagram, StyleUtil.TO_FIGURE_BACKGROUND_COLOR)) : gaService.manageColor(diagram, StyleUtil.EIP_FIGURE_BACKGROUND_COLOR);
        return figureBackgroundColor;
    }

    public static void markFigureHeaderArea(GraphicsAlgorithm area, int collapsedHeight) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "originalSectionHeight", Integer.toString(collapsedHeight));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "shapeKind", "header");
    }

    public static void markFigureTitleArea(GraphicsAlgorithm area, int iconWidth) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "imgWidth", Integer.toString(iconWidth));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "shapeKind", "title");
    }

    public static void markExpandableFigureArea(GraphicsAlgorithm area, int collapsedHeight) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "shapeKind", "expandable");
        Graphiti.getPeService().setPropertyValue((PropertyContainer)area, "originalSectionHeight", Integer.toString(collapsedHeight));
    }

    public static void storeCollapsedSize(ContainerShape containerShape) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedWidth", String.valueOf(containerShape.getGraphicsAlgorithm().getWidth()));
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "collapsedHeight", String.valueOf(containerShape.getGraphicsAlgorithm().getHeight()));
    }
}

