/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;

public class JobWaiterUtil {
    boolean isEndless = false;
    private Throwable exception = null;
    private List<Object> jobFamilies;

    public JobWaiterUtil(List<Object> jobFamilies) {
        this.jobFamilies = jobFamilies;
    }

    public void waitJob(IProgressMonitor monitor) {
        this.waitJob(20, monitor);
    }

    private void waitJob(int decreasingCounter, IProgressMonitor monitor) {
        int currentCounter;
        if (this.isEndless) {
            currentCounter = decreasingCounter;
            CamelEditorUIActivator.pluginLog().logInfo("log trace to ensure it is not looping");
        } else {
            if (decreasingCounter <= 0) {
                if (this.exception != null) {
                    CamelEditorUIActivator.pluginLog().logError(this.exception);
                } else {
                    CamelEditorUIActivator.pluginLog().logWarning("Waiting for job to finish unsuccessfully.");
                }
                return;
            }
            currentCounter = decreasingCounter - 1;
        }
        this.joinJobs(monitor, currentCounter);
    }

    private void joinJobs(IProgressMonitor monitor, int currentCounter) {
        try {
            for (Object jobFamily : this.jobFamilies) {
                Job.getJobManager().join(jobFamily, monitor);
            }
        }
        catch (InterruptedException | OperationCanceledException e) {
            this.exception = e;
            this.waitJob(currentCounter, monitor);
        }
    }

    public boolean isEndless() {
        return this.isEndless;
    }

    public void setEndless(boolean isEndless) {
        this.isEndless = isEndless;
    }
}

