/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.validation.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fusesource.ide.camel.model.service.core.model.CamelBasicModelElement;
import org.fusesource.ide.camel.validation.l10n.Messages;

public class EIPMandatoryChildValidator
implements IValidator {
    private static Set<String> eipWithMandatoryChildren = new HashSet<String>(Arrays.asList("choice", "aggregate", "filter", "idempotentConsumer", "intercept", "interceptFrom", "interceptSendToEndpoint", "loop", "multicast", "onCompletion", "pipeline", "policy", "sample", "split", "threads", "throttle", "transacted", "resequence"));

    public IStatus validate(Object value) {
        if (this.isComponentWithMandatoryChildren(value) && !this.hasChildren((CamelBasicModelElement)value)) {
            return ValidationStatus.error((String)Messages.eipWithoutChild);
        }
        return Status.OK_STATUS;
    }

    protected boolean hasChildren(CamelBasicModelElement value) {
        return !value.getChildElements().isEmpty();
    }

    protected boolean isComponentWithMandatoryChildren(Object value) {
        return value instanceof CamelBasicModelElement && eipWithMandatoryChildren.contains(((CamelBasicModelElement)value).getNodeTypeId());
    }
}

