/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fusesource.ide.foundation.core.internal.FoundationCoreActivator;
import org.jboss.tools.foundation.core.internal.Trace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class BundleUtils {
    public static void startBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String name = bundle.getSymbolicName();
            if (name.contains(containsName)) {
                Trace.trace((String)"/finer", (String)("About to start bundle: " + name));
                try {
                    bundle.start();
                }
                catch (Exception e) {
                    FoundationCoreActivator.pluginLog().logError("Failed to start: " + e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static void stopBundle(BundleContext context, String containsName) {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String name = bundle.getSymbolicName();
            if (name.contains(containsName)) {
                Trace.trace((String)"/finer", (String)("About to stop bundle: " + name));
                try {
                    bundle.stop();
                }
                catch (Exception e) {
                    FoundationCoreActivator.pluginLog().logError("Failed to start: " + e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    public static <T> T lookupService(BundleContext context, Class<T> aClass) {
        return BundleUtils.lookupService(context, aClass.getName(), aClass);
    }

    public static <T> T lookupService(BundleContext context, String name, Class<T> aClass) {
        ServiceReference ref = context.getServiceReference(name);
        return BundleUtils.getServiceFromRef(context, name, aClass, ref);
    }

    public static <T> List<T> lookupServices(BundleContext context, Class<T> aClass) throws InvalidSyntaxException {
        return BundleUtils.lookupServices(context, aClass.getName(), aClass);
    }

    public static <T> List<T> lookupServices(BundleContext context, String name, Class<T> aClass) throws InvalidSyntaxException {
        String filter = null;
        ServiceReference[] refs = context.getServiceReferences(name, filter);
        ArrayList<T> answer = new ArrayList<T>();
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service = BundleUtils.getServiceFromRef(context, name, aClass, ref);
                if (service != null) {
                    answer.add(service);
                }
                ++n2;
            }
        }
        return answer;
    }

    public static <T> Map<T, Map<String, Object>> lookupServicesMap(BundleContext context, Class<T> aClass) throws InvalidSyntaxException {
        return BundleUtils.lookupServicesMap(context, aClass.getName(), aClass);
    }

    public static <T> Map<T, Map<String, Object>> lookupServicesMap(BundleContext context, String name, Class<T> aClass) throws InvalidSyntaxException {
        String filter = null;
        ServiceReference[] refs = context.getServiceReferences(name, filter);
        HashMap<T, Map<String, Object>> answer = new HashMap<T, Map<String, Object>>();
        if (refs != null) {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                T service = BundleUtils.getServiceFromRef(context, name, aClass, ref);
                if (service != null) {
                    Map<String, Object> properties = BundleUtils.getPropertiesMap(ref);
                    answer.put(service, properties);
                }
                ++n2;
            }
        }
        return answer;
    }

    public static <T> Collection<ServiceReference<T>> findServiceReferences(BundleContext context, Class<T> c) throws InvalidSyntaxException {
        String filter = MessageFormat.format("(&(objectClass={0}))", c.getCanonicalName());
        context.createFilter(filter);
        return context.getServiceReferences(c, filter);
    }

    public static Properties getProperties(ServiceReference<?> ref) {
        String[] keys;
        Properties properties = new Properties();
        String[] stringArray = keys = ref.getPropertyKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }

    public static Map<String, Object> getPropertiesMap(ServiceReference<?> ref) {
        String[] keys;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String[] stringArray = keys = ref.getPropertyKeys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            properties.put(key, ref.getProperty(key));
            ++n2;
        }
        return properties;
    }

    protected static <T> T getServiceFromRef(BundleContext context, String name, Class<T> aClass, ServiceReference<?> ref) {
        if (ref == null) {
            Trace.trace((String)"/finer", (String)("No service for " + name));
        } else {
            Object value = context.getService(ref);
            if (aClass.isInstance(value)) {
                return aClass.cast(value);
            }
            FoundationCoreActivator.pluginLog().logWarning("Service for " + name + " is not an instanceof " + aClass.getCanonicalName() + " but was: " + value);
        }
        return null;
    }

    public static File getFileFromBundle(String bundleSymbolicName, String path) throws CoreException {
        Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
        URL url = null;
        try {
            URL fileUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            url = FileLocator.toFileURL((URL)fileUrl);
        }
        catch (IOException e) {
            String msg = "Cannot find file " + path + " in bundle " + bundle.getSymbolicName();
            Status status = new Status(4, "org.fusesource.ide.foundation.core", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        String location = url.getFile();
        return new File(location);
    }
}

