/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.foundation.core.internal.FoundationCoreActivator;
import org.fusesource.ide.foundation.core.util.ResourceModelUtils;
import org.fusesource.ide.foundation.core.xml.namespace.BlueprintNamespaceHandler;
import org.fusesource.ide.foundation.core.xml.namespace.FindCamelNamespaceHandler;
import org.fusesource.ide.foundation.core.xml.namespace.FindNamespaceHandlerSupport;
import org.fusesource.ide.foundation.core.xml.namespace.SpringNamespaceHandler;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class CamelUtils {
    public static final String CAMEL_EDITOR_ID = "org.fusesource.ide.camel.editor";
    public static final String FUSE_CAMEL_CONTENT_TYPE = "org.fusesource.ide.camel.editor.camelContentType";
    public static final String SPRING_BEANS_NAMESPACE = "http://www.springframework.org/schema/beans";
    private static final String GLOBAL_BEAN = "bean";
    private static FindNamespaceHandlerSupport blueprintXmlMatcher = new BlueprintNamespaceHandler();
    private static FindNamespaceHandlerSupport springXmlMatcher = new SpringNamespaceHandler();
    private static FindNamespaceHandlerSupport camelXmlMatcher = new FindCamelNamespaceHandler();

    private CamelUtils() {
    }

    public static boolean isCamelContextFile(String filePath) {
        return CamelUtils.matchesNamespace(filePath, camelXmlMatcher);
    }

    public static boolean isBlueprintFile(String filePath) {
        return CamelUtils.matchesNamespace(filePath, blueprintXmlMatcher);
    }

    public static boolean isSpringFile(String filePath) {
        return CamelUtils.matchesNamespace(filePath, springXmlMatcher);
    }

    private static boolean matchesNamespace(String filePath, FindNamespaceHandlerSupport support) {
        IFile file;
        String rawPath;
        IPath f;
        boolean matches = false;
        if (filePath != null && filePath.trim().length() > 0 && (f = Path.fromOSString((String)(rawPath = filePath.startsWith("file:") ? filePath.substring("file:".length()) : filePath))).toFile().exists() && f.toFile().isFile() && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(f)) != null) {
            matches = CamelUtils.matches(support, file);
        }
        return matches;
    }

    public static boolean matches(FindNamespaceHandlerSupport handler, IFile ifile) {
        try {
            File file = ResourceModelUtils.toFile(ifile);
            if (file != null) {
                handler.parseContents(new InputSource(new FileInputStream(file)));
                return handler.isNamespaceFound();
            }
        }
        catch (Exception e) {
            FoundationCoreActivator.pluginLog().logError("** Load failed. Using default model. **", (Throwable)e);
        }
        return false;
    }

    public static String getTagNameWithoutPrefix(Node node) {
        String nodeName;
        if (node == null || node.getNodeName() == null) {
            return null;
        }
        String prefix = node.getPrefix();
        String resVal = nodeName = node.getNodeName();
        if (prefix != null && prefix.trim().length() > 0 || nodeName.indexOf(58) != -1) {
            resVal = nodeName.substring(nodeName.indexOf(58) + 1);
        }
        return resVal;
    }

    public static boolean startsWithNamespace(Node child, String namespace) {
        if (child != null) {
            String nsUri = child.getNamespaceURI();
            if (nsUri == null && child.getParentNode() != null) {
                nsUri = child.getParentNode().getNamespaceURI();
            }
            return nsUri != null && nsUri.startsWith(namespace);
        }
        return false;
    }

    public static boolean startsWithOneOfNamespace(Node child, Collection<String> namespaces) {
        return namespaces.stream().filter(namespace -> CamelUtils.startsWithNamespace(child, namespace)).findAny().isPresent();
    }

    public static boolean isCamelNamespaceElement(Node child) {
        return CamelUtils.startsWithNamespace(child, "http://camel.apache.org/schema/");
    }

    public static boolean isGlobalBean(Node child) {
        return GLOBAL_BEAN.equals(CamelUtils.getTagNameWithoutPrefix(child)) && CamelUtils.startsWithOneOfNamespace(child, Arrays.asList("http://www.osgi.org/xmlns/blueprint/v1.0.0", "https://www.osgi.org/xmlns/blueprint/v1.0.0", SPRING_BEANS_NAMESPACE));
    }

    public static List<IFile> getFilesWithCamelContentType(IProject project) throws CoreException {
        IJavaProject javaProject;
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot ifr = iPackageFragmentRootArray[n2];
                if (ifr.getKind() == 1) {
                    files.addAll(CamelUtils.getFilesWithCamelContentTypeInResource(ifr.getCorrespondingResource()));
                }
                ++n2;
            }
        }
        project.hasNature("org.eclipse.wst.common.project.facet.core.nature");
        if (files.isEmpty()) {
            files.addAll(CamelUtils.getFilesWithCamelContentTypeInResource((IResource)project));
        }
        return files;
    }

    private static List<IFile> getFilesWithCamelContentTypeInResource(IResource root) throws CoreException {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        if (root != null) {
            root.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IContentDescription contentDescription = null;
                        try {
                            contentDescription = file.getContentDescription();
                        }
                        catch (CoreException e) {
                            if (e.getStatus().getCode() == 274) {
                                resource.refreshLocal(1, null);
                                contentDescription = file.getContentDescription();
                            }
                            throw e;
                        }
                        if (contentDescription != null && CamelUtils.FUSE_CAMEL_CONTENT_TYPE.equals(contentDescription.getContentType().getId())) {
                            files.add(file);
                        }
                    }
                    return true;
                }
            });
        }
        return files;
    }

    public static IEditorPart getDiagramEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow wbw;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (page = wbw.getActivePage()) != null && page.getActiveEditor() != null) {
            IEditorReference[] refs;
            IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                if (CAMEL_EDITOR_ID.equals(ref.getId()) && page.getActiveEditor().equals(ref.getEditor(false))) {
                    return ref.getEditor(true);
                }
                ++n2;
            }
        }
        return null;
    }

    public static IProject getCurrentProject() {
        IEditorPart ep = CamelUtils.getDiagramEditor();
        if (ep != null) {
            IProject wsProject = null;
            try {
                Object prj;
                Object designEditor = ep.getClass().getMethod("getDesignEditor", null).invoke((Object)ep, null);
                if (designEditor != null && (prj = designEditor.getClass().getMethod("getWorkspaceProject", null).invoke(designEditor, null)) != null && prj instanceof IProject) {
                    wsProject = (IProject)prj;
                    return wsProject;
                }
            }
            catch (Exception ex) {
                FoundationCoreActivator.pluginLog().logError("Unable to retrieve the currently opened project.", (Throwable)ex);
            }
        }
        return null;
    }
}

