/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.core.xml;

import java.util.HashMap;
import java.util.Map;

public class XmlEscapeUtility {
    protected static Map<Character, String> encodingMap = new HashMap<Character, String>();

    static {
        encodingMap.put(Character.valueOf('\"'), "&quot;");
        encodingMap.put(Character.valueOf('&'), "&amp;");
        encodingMap.put(Character.valueOf('<'), "&lt;");
        encodingMap.put(Character.valueOf('>'), "&gt;");
    }

    public static String escape(String text) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            XmlEscapeUtility.escape(c, sb);
            ++n2;
        }
        return sb.toString();
    }

    public static String unescape(String text) {
        String answer = text;
        for (Map.Entry<Character, String> e : encodingMap.entrySet()) {
            answer = answer.replaceAll(e.getValue(), e.getKey().toString());
        }
        return answer;
    }

    private static StringBuilder escape(char c, StringBuilder builder) {
        String encoded = encodingMap.get(Character.valueOf(c));
        return builder.append(encoded == null ? Character.toString(c) : encoded);
    }
}

