/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.form;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.fusesource.ide.foundation.ui.form.FormSupport;

public class FormPage
extends Page {
    private FormSupport form;
    private Composite control;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object source = event.getSource();
            IWorkbenchPart part = null;
            part = source instanceof IWorkbenchPart ? (IWorkbenchPart)source : FormPage.this.getSite().getPage().getActivePart();
            ((ISelectionListener)FormPage.this.form).selectionChanged(part, event.getSelection());
        }
    };

    public FormPage(FormSupport form) {
        this.form = form;
    }

    public FormSupport getForm() {
        return this.form;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        ISelectionProvider selectionProvider = pageSite.getSelectionProvider();
        if (selectionProvider != null && this.form instanceof ISelectionListener) {
            selectionProvider.addSelectionChangedListener(this.selectionListener);
        }
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout());
        this.form.createDialogArea(this.control);
    }

    public void dispose() {
        ISelectionProvider selectionProvider;
        IPageSite pageSite = this.getSite();
        if (pageSite != null && (selectionProvider = pageSite.getSelectionProvider()) != null && this.form instanceof ISelectionListener) {
            selectionProvider.removeSelectionChangedListener(this.selectionListener);
        }
        this.form.dispose();
        super.dispose();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.form.setFocus();
    }
}

