/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.propsrc;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.management.AttributeNotFoundException;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.properties.BooleanPropertyDescriptor;
import org.fusesource.ide.foundation.ui.properties.ComplexPropertyDescriptor;
import org.fusesource.ide.foundation.ui.properties.PropertyDescriptors;

public class BeanTypePropertyMetadata {
    private static Map<Class<?>, BeanTypePropertyMetadata> cache = new WeakHashMap();
    private Map<String, IPropertyDescriptor> propertyMap = new HashMap<String, IPropertyDescriptor>();
    private Map<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
    private TreeMap<String, IPropertyDescriptor> sortedMap = new TreeMap();
    private IPropertyDescriptor[] properties;

    public static synchronized BeanTypePropertyMetadata beanMetadata(Class<?> beanType) throws IntrospectionException {
        BeanTypePropertyMetadata answer = cache.get(beanType);
        if (answer == null) {
            answer = new BeanTypePropertyMetadata(beanType);
            cache.put(beanType, answer);
        }
        return answer;
    }

    public BeanTypePropertyMetadata(Class<?> beanType) throws IntrospectionException {
        PropertyDescriptor[] descriptors;
        BeanInfo beanInfo = Introspector.getBeanInfo(beanType);
        PropertyDescriptor[] propertyDescriptorArray = descriptors = beanInfo.getPropertyDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            Class<?> propertyType = descriptor.getPropertyType();
            if (propertyType != null) {
                String id = descriptor.getName();
                String displayName = PropertyDescriptors.getReadablePropertyName(descriptor);
                org.eclipse.ui.views.properties.PropertyDescriptor propertyDest = null;
                if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
                    propertyDest = new BooleanPropertyDescriptor(id, displayName);
                } else if (propertyType == String.class) {
                    propertyDest = new TextPropertyDescriptor((Object)id, displayName);
                } else if (propertyType.isPrimitive() || Number.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType)) {
                    propertyDest = new ComplexPropertyDescriptor(id, displayName, propertyType);
                } else {
                    FoundationUIActivator.pluginLog().logInfo("Ignoring property for " + beanType.getName() + " of name: " + displayName + " of type" + propertyType.getName());
                }
                this.descriptorMap.put(id, descriptor);
                if (propertyDest != null) {
                    this.propertyMap.put(id, (IPropertyDescriptor)propertyDest);
                    this.sortedMap.put(displayName, (IPropertyDescriptor)propertyDest);
                }
            }
            ++n2;
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.properties == null) {
            Collection<IPropertyDescriptor> values = this.sortedMap.values();
            this.properties = values.toArray(new IPropertyDescriptor[values.size()]);
        }
        return this.properties;
    }

    public Object getPropertyValue(Object bean, Object id) {
        PropertyDescriptor desc;
        if (bean != null && (desc = this.descriptorMap.get(id)) != null) {
            try {
                Method method = desc.getReadMethod();
                if (method != null) {
                    return method.invoke(bean, new Object[0]);
                }
            }
            catch (Exception e) {
                if (this.isAttributeNotFound(e)) {
                    FoundationUIActivator.pluginLog().logInfo("Attribute not supported; probably older version of the code? getter: " + id + " on " + bean + ". " + e);
                }
                FoundationUIActivator.pluginLog().logWarning("Could not invoke getter " + id + " on " + bean + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    private boolean isAttributeNotFound(Throwable e) {
        if (e instanceof AttributeNotFoundException) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException ue = (UndeclaredThrowableException)cause;
            return this.isAttributeNotFound(ue.getUndeclaredThrowable());
        }
        if (cause instanceof InvocationTargetException) {
            InvocationTargetException ie = (InvocationTargetException)cause;
            return this.isAttributeNotFound(ie.getTargetException());
        }
        if (cause != null) {
            return this.isAttributeNotFound(cause);
        }
        return false;
    }

    public boolean isPropertySet(Object bean, Object id) {
        return this.getPropertyValue(bean, id) != null;
    }

    public void setPropertyValue(Object bean, Object id, Object value) {
        Method method;
        PropertyDescriptor desc = this.descriptorMap.get(id);
        if (desc != null && (method = desc.getWriteMethod()) != null) {
            try {
                method.invoke(bean, value);
            }
            catch (Exception e) {
                FoundationUIActivator.pluginLog().logWarning("Could not invoke setter " + method + " on " + bean + ". " + e, (Throwable)e);
            }
        }
    }
}

