/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.dataStructures.InternalNode;
import org.eclipse.zest.layouts.dataStructures.InternalRelationship;

public class BigHorizontalShift
extends AbstractLayoutAlgorithm {
    private static double DELTA = 10.0;
    private static double VSPACING = 5.0;

    public BigHorizontalShift(int styles) {
        super(styles);
    }

    public static void setDelta(double newDelta) {
        DELTA = newDelta;
    }

    public static void setVSpacing(double newVSpacing) {
        VSPACING = newVSpacing;
    }

    protected void applyLayoutInternal(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double boundsX, double boundsY, double boundsWidth, double boundsHeight) {
        ArrayList<List<InternalNode>> row = new ArrayList<List<InternalNode>>();
        int i = 0;
        while (i < entitiesToLayout.length) {
            this.addToRowList(entitiesToLayout[i], row);
            ++i;
        }
        int heightSoFar = 0;
        Collections.sort(row, new Comparator<List<InternalNode>>(){

            @Override
            public int compare(List<InternalNode> a0, List<InternalNode> a1) {
                LayoutEntity node0 = a0.get(0).getLayoutEntity();
                LayoutEntity node1 = a1.get(0).getLayoutEntity();
                return (int)(node0.getYInLayout() - node1.getYInLayout());
            }
        });
        for (List list : row) {
            Collections.sort(list, new Comparator<InternalNode>(){

                @Override
                public int compare(InternalNode arg0, InternalNode arg1) {
                    return (int)(arg1.getLayoutEntity().getYInLayout() - arg0.getLayoutEntity().getYInLayout());
                }
            });
            Iterator iterator2 = list.iterator();
            int i2 = 0;
            int width = (int)(boundsWidth / 2.0 - (double)(list.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (((InternalNode)list.get(0)).getLayoutEntity().getHeightInLayout() + VSPACING * 8.0));
            while (iterator2.hasNext()) {
                InternalNode currentNode = (InternalNode)iterator2.next();
                double location = width + 10 * ++i2;
                currentNode.setLocation(location, (double)heightSoFar);
                width = (int)((double)width + currentNode.getLayoutEntity().getWidthInLayout());
            }
        }
    }

    private void addToRowList(InternalNode node, List<List<InternalNode>> list) {
        double layoutY = node.getLayoutEntity().getYInLayout();
        int i = 0;
        while (i < list.size()) {
            List<InternalNode> currentRow = list.get(i);
            InternalNode currentRowNode = currentRow.get(0);
            double currentRowY = currentRowNode.getLayoutEntity().getYInLayout();
            if (layoutY >= currentRowY - DELTA && layoutY <= currentRowY + DELTA) {
                currentRow.add(node);
                return;
            }
            ++i;
        }
        ArrayList<InternalNode> newRow = new ArrayList<InternalNode>();
        newRow.add(node);
        list.add(newRow);
    }

    protected int getCurrentLayoutStep() {
        return 0;
    }

    protected int getTotalNumberOfLayoutSteps() {
        return 0;
    }

    protected boolean isValidConfiguration(boolean asynchronous, boolean continuous) {
        return true;
    }

    protected void postLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider) {
    }

    protected void preLayoutAlgorithm(InternalNode[] entitiesToLayout, InternalRelationship[] relationshipsToConsider, double x, double y, double width, double height) {
    }

    public void setLayoutArea(double x, double y, double width, double height) {
    }
}

