/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.fusesource.ide.imports.sap.Messages;

public class SAPArchive {
    private static final String TAR_EXTENTION = ".tar";
    private static final String TAR_GZ_EXTENTION = ".tar.gz";
    private static final String TGZ_EXTENTION = ".tgz";
    private static final String ZIP_EXTENTION = ".zip";
    private static final String END_OF_LINE = "\n";
    protected static final Charset MANIFEST_ENCODING = StandardCharsets.UTF_8;
    public static final String MANIFEST_VERSION_VALUE = "1.0";
    public static final String BUNDLE_MANIFEST_VERSION_VALUE = "2";
    public static final String BUNDLE_ACTIVATION_POLICY_VALUE = "lazy";
    protected Map<String, byte[]> contents = new HashMap<String, byte[]>();

    protected void readArchiveFile(String filename, byte[] fileBytes) throws IOException {
        String fileNameLowerCased = filename.toLowerCase();
        if (fileNameLowerCased.endsWith(ZIP_EXTENTION)) {
            this.readZIPFile(fileBytes);
        } else if (fileNameLowerCased.endsWith(TGZ_EXTENTION) || fileNameLowerCased.endsWith(TAR_GZ_EXTENTION)) {
            this.readTGZFile(fileBytes);
        } else if (fileNameLowerCased.endsWith(TAR_EXTENTION)) {
            this.readTarFile(fileBytes);
        } else {
            throw new IOException(Messages.SAPArchive_InvalidFile);
        }
        if (this.contents.size() == 1) {
            filename = this.contents.keySet().iterator().next();
            fileBytes = this.contents.values().iterator().next();
            if (fileNameLowerCased.endsWith(ZIP_EXTENTION) || fileNameLowerCased.endsWith(TGZ_EXTENTION) || fileNameLowerCased.endsWith(TAR_GZ_EXTENTION) || fileNameLowerCased.endsWith(TAR_EXTENTION)) {
                this.readArchiveFile(filename, fileBytes);
            }
        }
    }

    protected void readZIPFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        byte[] buf = new byte[32768];
        ByteArrayInputStream fs = new ByteArrayInputStream(fileBytes);
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipInputStream zis = new ZipInputStream(fs);){
            this.read(buf, zis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void read(byte[] buf, ZipInputStream zis) throws IOException {
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                int numRead;
                while ((numRead = zis.read(buf, 0, buf.length)) != -1) {
                    os.write(buf, 0, numRead);
                }
                this.contents.put(entry.getName(), os.toByteArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            entry = zis.getNextEntry();
        }
    }

    protected void readTGZFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarInputStream tin = new TarInputStream((InputStream)new GZIPInputStream(new ByteArrayInputStream(fileBytes)));){
            this.read(tin);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void readTarFile(byte[] fileBytes) throws IOException {
        this.contents.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TarInputStream tin = new TarInputStream((InputStream)new ByteArrayInputStream(fileBytes));){
            this.read(tin);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void read(TarInputStream tin) throws IOException {
        TarEntry tarEntry = tin.getNextEntry();
        while (tarEntry != null) {
            if (!tarEntry.isDirectory()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    tin.copyEntryContents((OutputStream)os);
                    this.contents.put(tarEntry.getName(), os.toByteArray());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            tarEntry = tin.getNextEntry();
        }
    }

    protected void writeAttribute(StringBuilder manifest, String attributeName, String attributeValue) throws IOException {
        String line = String.valueOf(attributeName) + ": " + attributeValue;
        while (line.getBytes(MANIFEST_ENCODING).length > 70) {
            int index = 70;
            String section = line.substring(0, index >= line.length() ? line.length() - 1 : index);
            while (section.getBytes(MANIFEST_ENCODING).length > 70 && index > 0) {
                section = line.substring(0, --index);
            }
            if (index == 0) {
                throw new IOException();
            }
            manifest.append(String.valueOf(section) + END_OF_LINE);
            line = " " + line.substring(index);
        }
        manifest.append(String.valueOf(line) + END_OF_LINE);
    }

    public void readJARFile(byte[] fileBytes, Map<String, byte[]> contents) throws IOException {
        contents.clear();
        byte[] buf = new byte[32768];
        ByteArrayInputStream fs = new ByteArrayInputStream(fileBytes);
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarInputStream jis = new JarInputStream(fs);){
            ZipEntry entry = jis.getNextEntry();
            while (entry != null) {
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    int numRead;
                    while ((numRead = jis.read(buf, 0, buf.length)) != -1) {
                        os.write(buf, 0, numRead);
                    }
                    contents.put(entry.getName(), os.toByteArray());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                entry = jis.getNextEntry();
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void addJarEntry(JarOutputStream target, String jarEntryName, byte[] jarEntryContents, long lastModified) throws IOException {
        int numRead;
        byte[] buf = new byte[32768];
        JarEntry jarEntry = new JarEntry(jarEntryName);
        jarEntry.setTime(lastModified);
        target.putNextEntry(jarEntry);
        ByteArrayInputStream is = new ByteArrayInputStream(jarEntryContents);
        while ((numRead = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
            target.write(buf, 0, numRead);
        }
        target.closeEntry();
    }
}

