/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.fusesource.ide.foundation.ui.tree.ConnectedNode;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.foundation.ui.tree.RefreshableUI;
import org.jboss.tools.jmx.core.tree.Node;

public class ProducerNode
extends NodeSupport
implements ConnectedNode {
    private final ProducerViewMBean mbean;
    private final Node destinationNode;

    public ProducerNode(Node parent, Node destinationNode, ProducerViewMBean mbean) {
        super(parent);
        this.destinationNode = destinationNode;
        this.mbean = mbean;
        this.setPropertyBean(mbean);
    }

    public Node getDestinationNode() {
        return this.destinationNode;
    }

    public String toString() {
        try {
            return String.valueOf(this.mbean.getClientId()) + "/" + this.mbean.getSessionId();
        }
        catch (Exception exception) {
            this.getRefreshableUI().fireRefresh();
            return "";
        }
    }

    public RefreshableUI getRefreshableUI() {
        return this;
    }

    public List<Node> getConnectedTo() {
        return Collections.singletonList(this.getDestinationNode());
    }

    public boolean equals(Object obj) {
        return obj instanceof ProducerNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getConnection(), this.mbean, this.destinationNode);
    }
}

