/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.views.messages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.fusesource.ide.jmx.commons.Activator;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.IExchangeBrowser;
import org.fusesource.ide.jmx.commons.messages.contenttype.MessagesNamespaceXmlContentDescriber;

public class ExchangeBrowsers {
    public static IExchangeBrowser getSelectedExchangeBrowser(ISelection selection) {
        IExchangeBrowser answer = null;
        if (selection instanceof IStructuredSelection) {
            Object input = ((IStructuredSelection)selection).getFirstElement();
            answer = ExchangeBrowsers.toIExchangeBrowser(input);
        }
        return answer;
    }

    public static IExchangeBrowser toIExchangeBrowser(Object input) {
        IExchangeBrowser answer = null;
        if (input instanceof IExchangeBrowser) {
            answer = (IExchangeBrowser)input;
        } else if (input != null) {
            answer = Exchanges.asExchangeList(input);
            if (answer == null && input instanceof IFile) {
                IFile file = (IFile)input;
                try {
                    boolean messagesXml = MessagesNamespaceXmlContentDescriber.isXmlFormat(file);
                    if (messagesXml) {
                        answer = Exchanges.loadExchanges(file, file.getContents());
                    }
                }
                catch (Exception e) {
                    Activator.getLogger().info("Failed to parse " + file + " as message exchange XML: " + e, (Throwable)e);
                }
            }
            if (answer == null) {
                answer = (IExchangeBrowser)Platform.getAdapterManager().getAdapter(input, IExchangeBrowser.class);
            }
        }
        return answer;
    }
}

