/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.diagram.view;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.fusesource.ide.camel.editor.CamelEditor;
import org.fusesource.ide.camel.editor.utils.NodeUtils;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteElement;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.graph.GraphFilter;
import org.fusesource.ide.graph.GraphLabelProviderSupport;
import org.fusesource.ide.graph.GraphViewSupport;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.EndpointNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNode;
import org.fusesource.ide.jmx.camel.navigator.RouteNode;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.HasNodeStatisticsContainer;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;
import org.fusesource.ide.jmx.diagram.view.DiagramGraphLabelProvider;
import org.fusesource.ide.jmx.diagram.view.NodeGraphContentProvider;
import org.fusesource.ide.jmx.diagram.view.RouteGraphContentProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.Node;

public class DiagramView
extends GraphViewSupport {
    public static final String ID = "org.fusesource.ide.jmx.views.DiagramView";
    private Node selectedNode;
    AbstractCamelModelElement node;
    private NodeStatisticsContainer nodeStatisticsContainer;
    private IWorkbenchPart selectionPart;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected GraphLabelProviderSupport createGraphLabelProvider() {
        return new DiagramGraphLabelProvider(this);
    }

    protected NodeGraphContentProvider createGraphContentProvider() {
        return new NodeGraphContentProvider();
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.nodeStatisticsContainer;
    }

    protected GraphFilter createGraphFilter() {
        return new GraphFilter(this){

            protected boolean canFilterNode(Object element) {
                return !Objects.equal((Object)element, (Object)DiagramView.this.node) && !Objects.equal((Object)element, (Object)DiagramView.this.selectedNode);
            }
        };
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    String toNode;
                    IMessage in;
                    AbstractCamelModelElement node;
                    String toNode2;
                    IMessage in2;
                    if (!DiagramView.this.isRelevantSelectionSource(part, selection)) {
                        return;
                    }
                    Object firstSelection = Selections.getFirstSelection((ISelection)selection);
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (part.getClass().getName().equals("org.fusesource.ide.jmx.commons.views.messages.MessagesView") && firstSelection != null && (in2 = Exchanges.asMessage((Object)firstSelection)) != null && (toNode2 = in2.getToNode()) != null && DiagramView.this.selectNodeId(toNode2, in2.getEndpointUri())) {
                        return;
                    }
                    if (firstSelection != null) {
                        DiagramView.this.updateselection(firstSelection);
                    }
                    if ((node = NodeUtils.getSelectedNode((ISelection)selection)) != null && !(part instanceof CamelEditor)) {
                        if (node != DiagramView.this.node) {
                            DiagramView.this.updateGraph(node, part);
                        }
                    } else if (firstSelection instanceof Node) {
                        DiagramView.this.updateGraph((Node)firstSelection, part);
                    } else if (firstSelection instanceof IConnectionWrapper) {
                        DiagramView.this.viewer.setContentProvider((IContentProvider)new NodeGraphContentProvider());
                        DiagramView.this.setSelectedObjectOnly(firstSelection);
                    } else if (firstSelection != null && (in = Exchanges.asMessage((Object)firstSelection)) != null && (toNode = in.getToNode()) != null && DiagramView.this.selectNodeId(toNode, in.getEndpointUri())) {
                        return;
                    }
                    DiagramView.this.viewer.setSelection(selection);
                }
            });
        }
    }

    private boolean isRelevantSelectionSource(IWorkbenchPart part, ISelection selection) {
        boolean process = false;
        String partClassname = part.getClass().getName();
        if (partClassname.equals("org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator") || partClassname.equals("org.fusesource.ide.jmx.commons.views.messages.MessagesView") || partClassname.equals("org.eclipse.ui.views.properties.PropertySheet") || partClassname.equals("org.eclipse.wst.server.ui.internal.view.servers.ServersView") || partClassname.equals("org.eclipse.wst.server.ui.internal.cnf.ServersView2")) {
            process = true;
        }
        return process;
    }

    protected void updateselection(Object firstSelection) {
        if (firstSelection != null) {
            this.nodeStatisticsContainer = null;
            if (firstSelection instanceof HasNodeStatisticsContainer) {
                HasNodeStatisticsContainer hasNodeStatisticsContainer = (HasNodeStatisticsContainer)firstSelection;
                this.nodeStatisticsContainer = hasNodeStatisticsContainer.getNodeStatisticsContainer();
            } else if (firstSelection instanceof NodeStatisticsContainer) {
                this.nodeStatisticsContainer = (NodeStatisticsContainer)firstSelection;
            }
        } else {
            this.selectedNode = null;
            this.node = null;
            this.nodeStatisticsContainer = null;
            this.clearDiagramGraph();
        }
    }

    protected void clearDiagramGraph() {
        this.setSelectedObjectOnly(null);
        this.viewer.refresh();
    }

    public void updateGraph(AbstractCamelModelElement node, IWorkbenchPart part) {
        this.node = node;
        this.selectionPart = part;
        RouteGraphContentProvider contentProvider = new RouteGraphContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.setInputAndSelection(node, node);
    }

    public void updateGraph(Node node, IWorkbenchPart part) {
        this.selectedNode = node;
        this.selectionPart = part;
        this.node = null;
        this.viewer.setContentProvider((IContentProvider)new NodeGraphContentProvider());
        this.setSelectedObjectOnly(node);
    }

    protected boolean selectNodeId(String toNode, String endpointUri) {
        if (this.node != null) {
            AbstractCamelModelElement newSelection;
            AbstractCamelModelElement parent = this.getParentContainer();
            if (parent != null && (newSelection = parent.findNode(toNode)) != null) {
                if (newSelection instanceof CamelRouteElement) {
                    if (endpointUri != null) {
                        return this.selectEndpointUri(endpointUri);
                    }
                    CamelRouteElement route = (CamelRouteElement)newSelection;
                    if (!route.getInputs().isEmpty()) {
                        newSelection = (AbstractCamelModelElement)route.getInputs().get(0);
                    }
                }
                if (newSelection != null) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSelection));
                    return true;
                }
            }
        } else {
            Object[] objectArray = this.getViewer().getNodeElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object nodeElement = objectArray[n2];
                if (this.isCorrespondingElement(toNode, nodeElement)) {
                    this.viewer.setSelection((ISelection)new StructuredSelection(nodeElement));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isCorrespondingElement(String toNode, Object nodeElement) {
        return this.isCorrespondingNodeText(toNode, nodeElement) || this.isCorrespondingCamelContext(toNode, nodeElement) || this.isCorrespondingCamelRoute(toNode, nodeElement) || this.isCorrespondingCamelEndpoint(toNode, nodeElement) || this.isCorrespondingProcessor(toNode, nodeElement);
    }

    private boolean isCorrespondingNodeText(String toNode, Object nodeElement) {
        return nodeElement instanceof Node && toNode.equals(Strings.getOrElse((Object)nodeElement));
    }

    private boolean isCorrespondingProcessor(String toNode, Object nodeElement) {
        return nodeElement instanceof ProcessorNode && toNode.equals(((ProcessorNode)nodeElement).getNodeId());
    }

    private boolean isCorrespondingCamelEndpoint(String toNode, Object nodeElement) {
        return nodeElement instanceof EndpointNode && toNode.equals(((EndpointNode)nodeElement).getEndpointUri());
    }

    private boolean isCorrespondingCamelRoute(String toNode, Object nodeElement) {
        return nodeElement instanceof RouteNode && toNode.equals(((RouteNode)nodeElement).getNodeId());
    }

    private boolean isCorrespondingCamelContext(String toNode, Object nodeElement) {
        return nodeElement instanceof CamelContextNode && toNode.equals(((CamelContextNode)nodeElement).getContextId());
    }

    protected boolean selectEndpointUri(String uri) {
        CamelRouteElement route;
        AbstractCamelModelElement newSelection;
        AbstractCamelModelElement parent;
        if (this.node != null && (parent = this.getParentContainer()) instanceof CamelRouteElement && (newSelection = (route = (CamelRouteElement)parent).findEndpoint(uri)) != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSelection));
            return true;
        }
        return false;
    }

    protected AbstractCamelModelElement getParentContainer() {
        return this.node.getParent();
    }

    protected void doubleClickSelection(ISelection selection) {
        ISelectionProvider selectionProvider = Selections.getSelectionProvider((IWorkbenchPart)this.selectionPart);
        if (selectionProvider != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

