/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.propertytester;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.fusesource.ide.launcher.ui.Activator;

public class CamelLocalLaunchPropertyTester
extends PropertyTester {
    private static final String ORG_APACHE_CAMEL = "org.apache.camel";
    private static final String CAMEL_MAVEN_PLUGIN = "camel-maven-plugin";
    private static final String ORG_SPRINGFRAMEWORK_BOOT = "org.springframework.boot";
    private static final String SPRING_BOOT_MAVEN_PLUGIN = "spring-boot-maven-plugin";
    static final String IS_LOCAL_LAUNCH_AVAILABLE = "isLocalLaunchAvailable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Model mavenModel;
        IResource resource;
        if (receiver instanceof IAdaptable && (resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) != null && IS_LOCAL_LAUNCH_AVAILABLE.equals(property) && (mavenModel = this.retrieveMavenModel(resource)) != null) {
            List<Plugin> plugins = this.retrievePlugins(mavenModel);
            return this.containsCamelMavenPlugin(plugins) || this.containsSpringBootMavenPlugin(plugins);
        }
        return false;
    }

    Model retrieveMavenModel(IResource receiver) {
        IProject project = receiver.getProject();
        IMavenProjectFacade facade = this.retrieveMavenProjectFacade(project);
        if (facade != null) {
            try {
                return facade.getMavenProject((IProgressMonitor)new NullProgressMonitor()).getModel();
            }
            catch (CoreException e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
        return null;
    }

    private IMavenProjectFacade retrieveMavenProjectFacade(IProject project) {
        IMavenProjectRegistry mavenProjectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade facade = mavenProjectRegistry.getProject(project);
        if (facade == null) {
            facade = mavenProjectRegistry.create(project, (IProgressMonitor)new NullProgressMonitor());
        }
        return facade;
    }

    private List<Plugin> retrievePlugins(Model mavenModel) {
        Build build = mavenModel.getBuild();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (build != null) {
            plugins.addAll(build.getPlugins());
            PluginManagement pluginManagement = build.getPluginManagement();
            if (pluginManagement != null) {
                plugins.addAll(pluginManagement.getPlugins());
            }
        }
        return plugins;
    }

    private boolean containsCamelMavenPlugin(List<Plugin> plugins) {
        return plugins.parallelStream().filter(this::isCamelMavenPlugin).findFirst().isPresent();
    }

    private boolean containsSpringBootMavenPlugin(List<Plugin> plugins) {
        return plugins.parallelStream().filter(this::isSpringBootMavenPlugin).findFirst().isPresent();
    }

    private boolean isCamelMavenPlugin(Plugin plugin) {
        return ORG_APACHE_CAMEL.equals(plugin.getGroupId()) && CAMEL_MAVEN_PLUGIN.equals(plugin.getArtifactId());
    }

    private boolean isSpringBootMavenPlugin(Plugin plugin) {
        return ORG_SPRINGFRAMEWORK_BOOT.equals(plugin.getGroupId()) && SPRING_BOOT_MAVEN_PLUGIN.equals(plugin.getArtifactId());
    }
}

