/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelThread;

public class ThreadGarbageCollector
extends Job {
    private static final int TIME_BETWEEN_GARBAGE_COLLECTION = 60000;
    public static final long THREAD_LIFE_DURATION = 600000L;
    private final CamelDebugTarget camelDebugTarget;

    public ThreadGarbageCollector(CamelDebugTarget camelDebugTarget) {
        super("Thread CleanUp Service");
        this.camelDebugTarget = camelDebugTarget;
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!this.camelDebugTarget.isTerminated() && !monitor.isCanceled()) {
            try {
                this.checkAllThreads();
                Thread.sleep(60000L);
            }
            catch (InterruptedException | DebugException ex) {
                Activator.getLogger().error(ex);
            }
        }
        return Status.OK_STATUS;
    }

    private void checkAllThreads() throws DebugException {
        CamelThread[] camelThreadArray = this.camelDebugTarget.getThreads();
        int n = camelThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            CamelThread t = camelThreadArray[n2];
            if (!t.isSuspended() && System.currentTimeMillis() - t.getLastSuspended() > 600000L) {
                t.terminate();
            }
            ++n2;
        }
    }
}

