/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.camel.model.service.core.jmx.camel.IBacklogTracerHeader;
import org.fusesource.ide.jmx.commons.backlogtracermessage.Header;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.values.CamelHeaderValue;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeaderVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;

public class CamelHeadersValue
extends BaseCamelValue {
    private CamelHeadersVariable parent;
    private List<IVariable> fVariables = new ArrayList<IVariable>();
    private List<? extends IBacklogTracerHeader> headers;
    private CamelDebugTarget debugTarget;

    public CamelHeadersValue(CamelDebugTarget debugTarget, List<? extends IBacklogTracerHeader> headers, Class<?> type, CamelHeadersVariable parent) {
        super(debugTarget, headers != null ? Integer.toString(headers.hashCode()) : "", type);
        this.parent = parent;
        this.debugTarget = debugTarget;
        this.headers = headers;
        if (this.headers == null) {
            this.headers = new ArrayList<IBacklogTracerHeader>();
        }
        try {
            this.initHeaders();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void initHeaders() throws DebugException {
        for (IBacklogTracerHeader iBacklogTracerHeader : this.headers) {
            CamelHeaderVariable var = new CamelHeaderVariable(this.debugTarget, iBacklogTracerHeader.getKey(), String.class, this.parent);
            CamelHeaderValue val = new CamelHeaderValue(this.fTarget, iBacklogTracerHeader, var.getReferenceType());
            var.setValue(val);
            this.fVariables.add(var);
        }
    }

    public void addHeader(String key, String value) {
        try {
            try {
                this.debugTarget.getDebugger().setMessageHeaderOnBreakpoint(this.debugTarget.getSuspendedNodeId(), key, (Object)value);
                CamelHeaderVariable newVar = new CamelHeaderVariable(this.debugTarget, key, String.class, this.parent);
                CamelHeaderValue newVal = new CamelHeaderValue(this.debugTarget, (IBacklogTracerHeader)new Header(key, value, String.class.getName()), String.class);
                newVar.setValue(newVal);
                newVar.markChanged();
                this.fVariables.add(newVar);
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.fireCreationEvent();
            }
        }
        finally {
            this.fireCreationEvent();
        }
    }

    public void deleteHeader(String key) {
        try {
            try {
                IVariable v = null;
                this.debugTarget.getDebugger().removeMessageHeaderOnBreakpoint(this.debugTarget.getSuspendedNodeId(), key);
                for (IVariable var : this.fVariables) {
                    if (!((CamelHeaderValue)var.getValue()).getHeader().getKey().equals(key)) continue;
                    v = var;
                    break;
                }
                this.fVariables.remove(v);
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.fireChangeEvent(512);
            }
        }
        finally {
            this.fireChangeEvent(512);
        }
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return !this.fVariables.isEmpty();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "MessageHeaders";
    }

    @Override
    public String getValueString() throws DebugException {
        return this.fVariables.stream().map(v -> v.toString()).collect(Collectors.joining("\n"));
    }
}

