/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.fusesource.ide.camel.model.service.core.jmx.camel.IBacklogTracerHeader;
import org.fusesource.ide.camel.model.service.core.jmx.camel.ICamelDebuggerMBeanFacade;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.jmx.commons.backlogtracermessage.Header;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.values.CamelHeaderValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;

public class CamelHeaderVariable
extends BaseCamelVariable {
    private CamelHeadersVariable parent;

    public CamelHeaderVariable(CamelDebugTarget debugTarget, String name, Class<?> type, CamelHeadersVariable parent) {
        super(debugTarget, name, type);
        this.parent = parent;
    }

    @Override
    public boolean supportsValueModification() {
        return true;
    }

    @Override
    public void setValue(String expression) throws DebugException {
        IBacklogTracerHeader oldHeader = ((CamelHeaderValue)this.getValue()).getHeader();
        super.setValue(new CamelHeaderValue(this.fTarget, (IBacklogTracerHeader)new Header(oldHeader.getKey(), expression, oldHeader.getType()), Header.class));
        this.markChanged();
        this.fireChangeEvent(512);
        this.updateValueOnRuntime(((CamelDebugTarget)this.getDebugTarget()).getDebugger());
    }

    @Override
    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    @Override
    protected void updateValueOnRuntime(ICamelDebuggerMBeanFacade debugger) throws DebugException {
        IBacklogTracerHeader h = ((CamelHeaderValue)this.getValue()).getHeader();
        if (Strings.isBlank((String)h.getValue())) {
            this.delete();
        } else {
            debugger.setMessageHeaderOnBreakpoint(this.getCurrentEndpointNodeId(), h.getKey(), (Object)h.getValue(), h.getType());
        }
    }

    public String toString() {
        try {
            return String.format("%s = %s", this.getName(), this.getValue().getValueString());
        }
        catch (DebugException debugException) {
            return super.toString();
        }
    }

    public void delete() {
        try {
            this.parent.deleteHeader(((CamelHeaderValue)this.getValue()).getHeader().getKey());
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }
}

