/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.actions;

import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.projecttemplates.actions.ChangeCamelVersionJob;
import org.fusesource.ide.projecttemplates.actions.ui.SwitchCamelVersionWizard;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;

public class SwitchCamelVersionAction
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            String newVersion;
            IProject project = (IProject)Selections.getFirstSelection((ISelection)this.selection);
            String currentVersion = new CamelMavenUtils().getCamelVersionFromMaven(project, false);
            SwitchCamelVersionWizard switchCamelVersionWizard = new SwitchCamelVersionWizard(currentVersion);
            if (new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)switchCamelVersionWizard).open() == 0 && !(newVersion = switchCamelVersionWizard.getSelectedCamelVersion()).equalsIgnoreCase(currentVersion)) {
                if (this.shouldWarnAboutDozerAPIBreak(currentVersion, newVersion)) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.dozerInformationApiBreakTitle, (String)Messages.dozerInformationApiBreakMessage);
                }
                new ChangeCamelVersionJob(project, newVersion).schedule();
            }
        } else {
            ProjectTemplatesActivator.pluginLog().logError("Cannot determine target project with selection of type " + this.selection.getClass().getName());
        }
    }

    protected boolean shouldWarnAboutDozerAPIBreak(String currentVersion, String newVersion) {
        ComparableVersion maxVersion = new ComparableVersion("2.20.0");
        return maxVersion.compareTo(new ComparableVersion(newVersion)) <= 0 && maxVersion.compareTo(new ComparableVersion(currentVersion)) > 0 || maxVersion.compareTo(new ComparableVersion(newVersion)) > 0 && maxVersion.compareTo(new ComparableVersion(currentVersion)) <= 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

