/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters;

import org.apache.maven.model.Dependency;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.fusesource.ide.camel.model.service.core.util.OnlineArtifactVersionSearcher;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;

public abstract class AbstractProjectTemplate {
    public boolean supportsDSL(CamelDSLType type) {
        return true;
    }

    public final boolean create(IProject project, CommonNewProjectMetaData projectMetaData, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean ok = this.getCreator(projectMetaData).create(project, projectMetaData, (IProgressMonitor)subMonitor.newChild(30));
        if (ok) {
            this.refreshProjectSync(project, monitor);
            ok = this.getConfigurator().configure(project, projectMetaData, (IProgressMonitor)subMonitor.newChild(30));
            this.refreshProjectSync(project, (IProgressMonitor)subMonitor.newChild(15));
            project.getFolder("bin").delete(true, (IProgressMonitor)subMonitor.newChild(5));
            project.getFolder("build").delete(true, (IProgressMonitor)subMonitor.newChild(5));
            this.refreshProjectSync(project, (IProgressMonitor)subMonitor.newChild(15));
        }
        return ok;
    }

    private void refreshProjectSync(IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, (IProgressMonitor)subMonitor.split(1));
        }
        catch (InterruptedException | OperationCanceledException e) {
            ProjectTemplatesActivator.pluginLog().logError(e);
        }
        subMonitor.setWorkRemaining(0);
    }

    public abstract TemplateConfiguratorSupport getConfigurator();

    public abstract TemplateCreatorSupport getCreator(CommonNewProjectMetaData var1);

    public boolean isCompatible(String camelVersion) {
        return true;
    }

    public String getArtifactLastVersion(String groupId, String artifactId) {
        Dependency bomToSearch = new Dependency();
        bomToSearch.setGroupId(groupId);
        bomToSearch.setArtifactId(artifactId);
        try {
            return new OnlineArtifactVersionSearcher().findLatestVersion((IProgressMonitor)new NullProgressMonitor(), bomToSearch);
        }
        catch (CoreException e) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
            return null;
        }
    }
}

