/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;

public class ProjectTemplatePatcher {
    private CommonNewProjectMetaData projectMetaData;

    public ProjectTemplatePatcher(CommonNewProjectMetaData projectMetaData) {
        this.projectMetaData = projectMetaData;
    }

    public void patch(Model m2m, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (this.areAriesProxyDependenciesToBeRemoved(this.projectMetaData)) {
            this.removeAriesProxyDependencies(m2m, (IProgressMonitor)subMonitor.split(1));
        }
        subMonitor.setWorkRemaining(0);
    }

    private void removeAriesProxyDependencies(Model m2m, IProgressMonitor monitor) {
        List dependencies = m2m.getDependencies();
        if (dependencies != null) {
            List<Dependency> toRemove = this.getDependenciesToRemove(dependencies);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)toRemove.size());
            toRemove.forEach(depToRemove -> {
                m2m.removeDependency(depToRemove);
                subMonitor.worked(1);
            });
        }
    }

    protected List<Dependency> getDependenciesToRemove(List<Dependency> dependencies) {
        return dependencies.stream().filter(dep -> dep != null && "org.apache.aries.proxy".equalsIgnoreCase(dep.getGroupId())).collect(Collectors.toList());
    }

    private boolean areAriesProxyDependenciesToBeRemoved(CommonNewProjectMetaData projectMetaData) {
        String camelVersion;
        String string = camelVersion = Strings.isBlank((String)projectMetaData.getCamelVersion()) ? new CamelMavenUtils().getCamelVersionFromProjectName(projectMetaData.getProjectName()) : projectMetaData.getCamelVersion();
        if (new CamelMavenUtils().isRedHatBrandedVersion(camelVersion)) {
            ComparableVersion v1 = new ComparableVersion(camelVersion);
            ComparableVersion v2 = new ComparableVersion("2.17.0.redhat-630283");
            return v1.compareTo(v2) >= 0;
        }
        return false;
    }
}

