/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import java.io.File;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeCamelVersionFinder {
    static final String FUSE_RUNTIME_PREFIX = "org.fusesource.ide.fuseesb.runtime.";
    static final String EAP_RUNTIME_PREFIX = "org.jboss.ide.eclipse.as.runtime.eap.";
    private static final String CAMEL_CORE_LIB_PREFIX = "camel-core-";
    private static final String CAMEL_CORE_LIB_SUFFIX = ".jar";

    public String getVersion(IRuntime runtime) {
        if (runtime != null) {
            if (this.isJBossFuseRuntime(runtime)) {
                return this.getVersionForJbossFuseRuntime(runtime);
            }
            if (this.isFuseOnEAPRuntime(runtime)) {
                return this.getVersionForEAPRuntime(runtime);
            }
        }
        return "unknown";
    }

    private String getVersionForEAPRuntime(IRuntime runtime) {
        String[] versions;
        File camelFolder = this.getCamelFolderOnEAP(runtime);
        if (camelFolder.exists() && (versions = camelFolder.list((dir, name) -> {
            String lowerCaseName = name.toLowerCase();
            return lowerCaseName.startsWith(CAMEL_CORE_LIB_PREFIX) && lowerCaseName.endsWith(CAMEL_CORE_LIB_SUFFIX);
        })).length == 1) {
            String jarName = versions[0];
            return jarName.substring(jarName.indexOf(CAMEL_CORE_LIB_PREFIX) + CAMEL_CORE_LIB_PREFIX.length(), jarName.indexOf(CAMEL_CORE_LIB_SUFFIX));
        }
        return "unknown";
    }

    private File getCamelFolderOnEAP(IRuntime runtime) {
        return runtime.getLocation().append("modules").append("system").append("layers").append("fuse").append("org").append("apache").append("camel").append("core").append("main").toFile();
    }

    private String getVersionForJbossFuseRuntime(IRuntime runtime) {
        String[] versions;
        File camelFolder = this.getCamelFolderOnFuse(runtime);
        if (camelFolder.exists() && (versions = camelFolder.list()).length == 1) {
            return versions[0];
        }
        return "unknown";
    }

    private File getCamelFolderOnFuse(IRuntime runtime) {
        return runtime.getLocation().append("system").append("org").append("apache").append("camel").append("camel-core").toFile();
    }

    private boolean isFuseOnEAPRuntime(IRuntime runtime) {
        return this.isRuntimeOfType(runtime, EAP_RUNTIME_PREFIX);
    }

    private boolean isJBossFuseRuntime(IRuntime runtime) {
        return this.isRuntimeOfType(runtime, FUSE_RUNTIME_PREFIX);
    }

    private boolean isRuntimeOfType(IRuntime runtime, String runtimeType) {
        return runtime.getRuntimeType().getId().startsWith(runtimeType);
    }
}

