/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages.model;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.wizards.pages.model.CategoryItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.NameAndWeightSupport;

public class TemplateItem
implements NameAndWeightSupport {
    private String id;
    private String name;
    private String description;
    private List<String> keywords = new ArrayList<String>();
    private int weight;
    private CategoryItem category;
    private AbstractProjectTemplate template;

    public TemplateItem(String id, String name, String description, int weight, CategoryItem category, AbstractProjectTemplate template, String keywords) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.weight = weight;
        this.category = category;
        this.template = template;
        this.initKeywords(keywords);
    }

    private void initKeywords(String keywordsString) {
        if (keywordsString != null) {
            String[] words;
            String[] stringArray = words = keywordsString.split(" ");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (!Strings.isBlank((String)(word = word.trim())) && !this.keywords.contains(word)) {
                    this.keywords.add(word);
                }
                ++n2;
            }
        }
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public CategoryItem getCategory() {
        return this.category;
    }

    public AbstractProjectTemplate getTemplate() {
        return this.template;
    }

    public boolean isCompatible(String camelVersion) {
        return this.template.isCompatible(camelVersion);
    }
}

