/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fuse.core.bean;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.fusesource.ide.server.fuse.core.Activator;
import org.jboss.ide.eclipse.as.core.server.bean.AbstractCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeFuse7x
extends ServerBeanType {
    private static final String FUSE_BRANDING_JAR_PREFIX = "fuse-branding-";
    private static final String KEY_VERSION = "version";
    private static final String VERSION_FILE = "version.properties";
    public static final String V70 = "7.0";
    public static final String V7X = "7.";

    protected ServerBeanTypeFuse7x() {
        super("FUSE7x", "JBoss Fuse 7.x", "lib", (ICondition)new Fuse7xServerTypeCondition());
    }

    public static class Fuse7xServerTypeCondition
    extends AbstractCondition {
        public boolean isServerRoot(File location) {
            return Fuse7xServerTypeCondition.isFuseRuntime(location);
        }

        public String getFullVersion(File location, File systemFile) {
            File jarFile = Fuse7xServerTypeCondition.getBrandingJarFile(systemFile);
            return Fuse7xServerTypeCondition.getFuseVersionFromBrandingFile(jarFile);
        }

        protected static String getFuseVersionFromBrandingFile(File jarFile) {
            if (jarFile == null) {
                return null;
            }
            String name = jarFile.getName();
            int startPos = name.indexOf(ServerBeanTypeFuse7x.FUSE_BRANDING_JAR_PREFIX) + ServerBeanTypeFuse7x.FUSE_BRANDING_JAR_PREFIX.length();
            return name.substring(startPos, name.length() - ".jar".length());
        }

        protected static File getBrandingJarFile(File jarFilePath) {
            File[] files = jarFilePath.listFiles((dir, name) -> name.toLowerCase().startsWith(ServerBeanTypeFuse7x.FUSE_BRANDING_JAR_PREFIX) && name.toLowerCase().endsWith(".jar"));
            if (files != null && files.length > 0) {
                return files[0];
            }
            return null;
        }

        protected static boolean isFuseRuntime(File location) {
            File versionFile = new File(location, ServerBeanTypeFuse7x.VERSION_FILE);
            if (versionFile.exists() && versionFile.isFile()) {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(versionFile));
                    String version = p.getProperty(ServerBeanTypeFuse7x.KEY_VERSION);
                    if (version != null && version.startsWith(ServerBeanTypeFuse7x.V7X)) {
                        return true;
                    }
                }
                catch (IOException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
            String mainFolder = new ServerBeanTypeFuse7x().getSystemJarPath();
            File f = new File(String.valueOf(location.getPath()) + File.separator + mainFolder);
            File brandingJar = Fuse7xServerTypeCondition.getBrandingJarFile(f);
            String version = Fuse7xServerTypeCondition.getFuseVersionFromBrandingFile(brandingJar);
            return version != null && brandingJar.getName().startsWith(ServerBeanTypeFuse7x.FUSE_BRANDING_JAR_PREFIX) && version.startsWith(ServerBeanTypeFuse7x.V7X);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeFuse7x.V70)) {
                return "org.fusesource.ide.fuseesb.server.70";
            }
            if (version.startsWith(ServerBeanTypeFuse7x.V7X)) {
                return "org.fusesource.ide.fuseesb.server.70";
            }
            return null;
        }
    }
}

