/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.bean;

import java.io.File;
import org.fusesource.ide.server.karaf.core.bean.BaseKarafServerTypeCondition;
import org.jboss.ide.eclipse.as.core.server.bean.ICondition;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class ServerBeanTypeKaraf4x
extends ServerBeanType {
    private static final String KARAF4X_RELEASE_VERSION = "Bundle-Version";
    public static final String V4_0 = "4.0";
    public static final String V4_1 = "4.1";
    public static final String V4_X = "4.";

    protected ServerBeanTypeKaraf4x() {
        super("KARAF4x", "Apache Karaf 4.x", "lib" + File.separator + "boot" + File.separator + "org.apache.karaf.main.jar", (ICondition)new Karaf4xServerTypeCondition());
    }

    public static class Karaf4xServerTypeCondition
    extends BaseKarafServerTypeCondition {
        public boolean isServerRoot(File location) {
            return Karaf4xServerTypeCondition.checkKarafVersion(location, ServerBeanTypeKaraf4x.KARAF4X_RELEASE_VERSION, ServerBeanTypeKaraf4x.V4_X) && !Karaf4xServerTypeCondition.isIntegratedKaraf(location);
        }

        public String getFullVersion(File location, File systemFile) {
            File jarFile = Karaf4xServerTypeCondition.getRealJarFile(systemFile.getParentFile());
            return super.getFullVersion(location, jarFile);
        }

        protected static File getRealJarFile(File jarFilePath) {
            File[] files = jarFilePath.listFiles((dir, name) -> name.toLowerCase().startsWith("org.apache.karaf.main-") && name.toLowerCase().endsWith(".jar"));
            if (files != null && files.length > 0) {
                return files[0];
            }
            return jarFilePath;
        }

        protected static boolean checkKarafVersion(File location, String property, String propPrefix) {
            String mainFolder = new ServerBeanTypeKaraf4x().getSystemJarPath();
            File f = new File(String.valueOf(location.getPath()) + File.separator + mainFolder);
            String value = ServerBeanTypeKaraf4x.getJarProperty((File)Karaf4xServerTypeCondition.getRealJarFile(f.getParentFile()), (String)property);
            return value != null && value.startsWith(propPrefix);
        }

        public String getServerTypeId(String version) {
            if (version.equals(ServerBeanTypeKaraf4x.V4_0)) {
                return "org.fusesource.ide.karaf.server.40";
            }
            if (version.equals(ServerBeanTypeKaraf4x.V4_1)) {
                return "org.fusesource.ide.karaf.server.41";
            }
            if (version.startsWith(ServerBeanTypeKaraf4x.V4_X)) {
                return "org.fusesource.ide.karaf.server.41";
            }
            return null;
        }

        protected static boolean isIntegratedKaraf(File location) {
            File libFolder = new File(location + File.separator + "lib");
            File[] files = libFolder.listFiles((dir, name) -> name.toLowerCase().startsWith("fuse-branding-"));
            return files != null && files.length > 0;
        }
    }
}

