/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.bean.KarafBeanProvider;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBean;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanType;

public class KarafRuntimeLocator
extends RuntimeLocatorDelegate {
    private static final int MAX_RECURSION_DEPTH = 5;

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        if (path == null) {
            monitor.done();
            return;
        }
        File f = new File(path.toOSString());
        if (f.isDirectory()) {
            monitor.beginTask("Searching for Apache Karaf in " + f.getPath() + "...", -1);
            this.search(f, listener, monitor);
            monitor.worked(1);
        }
        monitor.done();
    }

    public void search(File folder, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        this.search(folder, listener, 0, monitor);
    }

    public void search(File folder, RuntimeLocatorDelegate.IRuntimeSearchListener listener, int recursionLevel, IProgressMonitor monitor) {
        File[] files;
        if (monitor.isCanceled() || recursionLevel == 5) {
            return;
        }
        if (!this.checkRuntime(folder, listener, monitor)) {
            return;
        }
        File[] fileArray = files = folder.listFiles(File::isDirectory);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            monitor.beginTask("Searching for Apache Karaf in " + f.getPath() + "...", -1);
            this.search(f, listener, recursionLevel + 1, monitor);
            monitor.worked(1);
            ++n2;
        }
    }

    private boolean checkRuntime(File karafHome, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        monitor.beginTask("Examine possible Apache Karaf installation at " + karafHome.getPath() + "...", -1);
        IRuntimeWorkingCopy runtime = this.getRuntimeFromDir(karafHome, monitor);
        monitor.worked(1);
        if (runtime != null) {
            listener.runtimeFound(runtime);
            return true;
        }
        return false;
    }

    public IRuntimeWorkingCopy getRuntimeFromDir(File dir, IProgressMonitor monitor) {
        IServerType t;
        String serverType;
        String absolutePath = dir.getAbsolutePath();
        ServerBeanLoader l = new ServerBeanLoader(dir);
        ServerBean sb = l.getServerBean();
        if (this.isValidServerBeanType(sb) && (serverType = l.getServerAdapterId()) != null && (t = ServerCore.findServerType((String)serverType)) != null) {
            IRuntimeType rtt = t.getRuntimeType();
            try {
                IRuntimeWorkingCopy runtime = rtt.createRuntime(rtt.getId(), monitor);
                runtime.setLocation((IPath)new Path(absolutePath));
                IStatus status = runtime.validate(monitor);
                if (status == null || status.getSeverity() != 4) {
                    return runtime;
                }
            }
            catch (Exception e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
        return null;
    }

    protected boolean isValidServerBeanType(ServerBean sb) {
        if (sb != null) {
            ServerBeanType type = sb.getBeanType();
            return ((Object)((Object)KarafBeanProvider.KARAF_2x)).equals(type) || ((Object)((Object)KarafBeanProvider.KARAF_3x)).equals(type) || ((Object)((Object)KarafBeanProvider.KARAF_4x)).equals(type);
        }
        return false;
    }
}

