/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.runtime.classpath;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.server.core.IRuntime;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.server.karaf.core.Activator;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.RuntimeClasspathCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.PathProviderResolutionUtil;

public class KarafProjectRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate {
    static final IPath CONTAINER_PATH = new Path("org.eclipse.jst.server.core.container").append("org.fusesource.ide.server.karaf.core.runtime.classpath.runtimeTarget");

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        IPath installPath = runtime.getLocation();
        if (installPath == null) {
            return new IClasspathEntry[0];
        }
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        String runtimeId = runtime.getRuntimeType().getId();
        if (runtimeId.indexOf(".fuseesb.runtime.") != -1 || runtimeId.indexOf(".karaf.runtime.") != -1) {
            IPath libFolder = installPath.append("lib");
            KarafProjectRuntimeClasspathProvider.addLibraryEntries(list, (File)libFolder.toFile(), (boolean)true);
            IPath dataFolder = installPath.append("data").append("cache");
            this.collectDeployedBundles(list, dataFolder);
        }
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    private void collectDeployedBundles(List<IClasspathEntry> list, IPath folder) {
        File[] fileArray = folder.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File subDir) {
                return subDir.isDirectory() && subDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().trim().equals("bundle.info");
                    }
                }).length == 1;
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                File subFolder = fileArray[n2];
                File f = this.getJarFromFolder(subFolder);
                if (f != null) {
                    IClasspathEntry cpe;
                    block14: {
                        cpe = null;
                        try {
                            Throwable throwable = null;
                            Object var10_12 = null;
                            try (JarFile jf = new JarFile(f);){
                                Manifest mf = jf.getManifest();
                                String version = mf.getMainAttributes().getValue("Bundle-Version");
                                String symbolicName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                                if (Strings.isBlank((String)symbolicName) || Strings.isBlank((String)version)) break block14;
                                IPath bundleFolder = folder.append(subFolder.getName()).append(f.getParentFile().getName()).append(f.getName());
                                cpe = JavaCore.newLibraryEntry((IPath)bundleFolder, null, null);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException ex) {
                            Activator.getLogger().error((Throwable)ex);
                            break block15;
                        }
                    }
                    if (cpe != null) {
                        list.add(cpe);
                    }
                }
            }
            ++n2;
        }
    }

    private File getJarFromFolder(File folder) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File sf = fileArray[n2];
            if (sf.isDirectory() && sf.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.trim().equalsIgnoreCase("bundle.jar");
                }
            }).length == 1) {
                return new File(sf, "bundle.jar");
            }
            ++n2;
        }
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainerFromRuntime(IRuntime runtime) {
        if (runtime == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] runtimeClasspath = RuntimeClasspathCache.getInstance().getEntries(runtime);
        if (runtimeClasspath != null) {
            return runtimeClasspath;
        }
        IRuntimePathProvider[] sets = CustomRuntimeClasspathModel.getInstance().getEntries(runtime.getRuntimeType());
        IPath[] allPaths = PathProviderResolutionUtil.getAllPaths((IRuntime)runtime, (IRuntimePathProvider[])sets);
        runtimeClasspath = PathProviderResolutionUtil.getClasspathEntriesForResolvedPaths((IPath[])allPaths);
        RuntimeClasspathCache.getInstance().cacheEntries(runtime, runtimeClasspath);
        return runtimeClasspath;
    }
}

