/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.IConfigurationPropertyProvider;

public class BaseConfigPropertyProvider
implements IConfigurationPropertyProvider {
    private Properties configProps = new Properties();
    private File propertyFile = null;

    public BaseConfigPropertyProvider(File propertyFile) {
        this.propertyFile = propertyFile;
        this.loadPropertiesFromFile();
    }

    @Override
    public String getConfigurationProperty(String propertyName) {
        return this.getConfigurationProperty(propertyName, null);
    }

    @Override
    public String getConfigurationProperty(String propertyName, String defaultValue) {
        return this.configProps.getProperty(propertyName, defaultValue);
    }

    public Enumeration<Object> getPropertyKeys() {
        return this.configProps.keys();
    }

    private void loadPropertiesFromFile() {
        this.configProps.clear();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.propertyFile));){
                this.configProps.load(bis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public void reload() {
        this.loadPropertiesFromFile();
    }
}

