/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fusesource.ide.server.karaf.core.server.Karaf3xServerDelegate;
import org.fusesource.ide.server.karaf.core.server.subsystems.Karaf4xStartupLaunchConfigurator;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;

public class Karaf4xServerDelegate
extends Karaf3xServerDelegate {
    @Override
    public IStatus validate() {
        if (this.getServer() != null && this.getServer().getRuntime() != null) {
            IPath rtLoc = this.getServer().getRuntime().getLocation();
            String version = KarafUtils.getVersion(rtLoc.toFile());
            IPath karafJar = rtLoc.append("lib").append("boot").append(String.format("org.apache.karaf.main-%s.jar", version.replaceAll(".SNAPSHOT", "-SNAPSHOT")));
            if (rtLoc.toFile().exists() && rtLoc.toFile().isDirectory() && karafJar.toFile().exists() && karafJar.toFile().isFile()) {
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public ILaunchConfigConfigurator getLaunchConfigurator() throws CoreException {
        return new Karaf4xStartupLaunchConfigurator(this.getServer());
    }
}

