/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.poller.BaseKarafPoller;
import org.fusesource.ide.server.karaf.core.poller.PollThread;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.jboss.ide.eclipse.as.core.server.ILaunchConfigConfigurator;
import org.jboss.ide.eclipse.as.core.server.IPollResultListener;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller2;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IShutdownControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.launch.AbstractStartJavaServerLaunchDelegate;

public class Karaf2xLaunchController
extends AbstractSubsystemController
implements ILaunchServerController,
ILaunchConfigurationDelegate2,
IShutdownControllerDelegate {
    private AbstractStartJavaServerLaunchDelegate launchDelegate;
    private IPollResultListener pollListener = new IPollResultListener(){

        public void stateNotAsserted(boolean expectedState, boolean currentState) {
            ((ControllableServerBehavior)Karaf2xLaunchController.this.getControllableBehavior()).setServerStopped();
        }

        public void stateAsserted(boolean expectedState, boolean currentState) {
            ((ControllableServerBehavior)Karaf2xLaunchController.this.getControllableBehavior()).setServerStarted();
        }
    };

    private AbstractStartJavaServerLaunchDelegate getLaunchDelegate() {
        if (this.launchDelegate == null) {
            this.launchDelegate = new AbstractStartJavaServerLaunchDelegate(){

                protected void initiatePolling(IServer server) {
                    PollThread pollThread = new PollThread(true, (IServerStatePoller)Karaf2xLaunchController.this.getPoller(), Karaf2xLaunchController.this.pollListener, server);
                    Karaf2xLaunchController.this.getControllableBehavior().putSharedData("karafPoller", (Object)pollThread);
                    pollThread.start();
                }

                protected void cancelPolling(IServer server) {
                    Object o = Karaf2xLaunchController.this.getControllableBehavior().getSharedData("karafPoller");
                    if (o instanceof PollThread) {
                        PollThread pollThread = (PollThread)o;
                        pollThread.cancel();
                    }
                }

                protected void logStatus(IServer server, IStatus stat) {
                    Activator.getDefault().getLog().log(stat);
                }

                protected IStatus isServerStarted(IServer server) {
                    return Karaf2xLaunchController.this.getPoller().getCurrentStateSynchronous(Karaf2xLaunchController.this.getServer());
                }

                protected void validateServerStructure(IServer server) throws CoreException {
                }
            };
        }
        return this.launchDelegate;
    }

    private IServerStatePoller2 getPoller() {
        return new BaseKarafPoller();
    }

    public IStatus canStart(String launchMode) {
        KarafServerDelegate d = (KarafServerDelegate)this.getServer().loadAdapter(KarafServerDelegate.class, null);
        return d == null ? Status.CANCEL_STATUS : d.validate();
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigConfigurator configurator = this.getConfigurator();
        if (configurator != null) {
            configurator.configure(workingCopy);
        }
    }

    protected ILaunchConfigConfigurator getConfigurator() throws CoreException {
        ILaunchConfigConfigurator cfg;
        KarafServerDelegate serverDel = (KarafServerDelegate)this.getServer().loadAdapter(KarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        if (serverDel != null && (cfg = serverDel.getLaunchConfigurator()) != null) {
            return cfg;
        }
        throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.server.karaf.core", "Unable to retrieve a launch configuration for server type " + this.getServer().getServerType().getId()));
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.getLaunchDelegate().launch(configuration, mode, launch, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getLaunchDelegate().getLaunch(configuration, mode);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().buildForLaunch(configuration, mode, monitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().finalLaunchCheck(configuration, mode, monitor);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return this.getLaunchDelegate().preLaunchCheck(configuration, mode, monitor);
    }

    public IServerShutdownController getShutdownController() {
        try {
            return (IServerShutdownController)((IControllableServerBehavior)this.getServer()).getController("shutdown");
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
            return null;
        }
    }
}

