/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.core.server.subsystems;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.fusesource.ide.server.karaf.core.server.subsystems.OSGiBundleState;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;

public class OSGiBundleStateController
extends AbstractSubsystemController
implements IModuleStateController {
    private static final String BUNDLE_STATE_PREFIX = "karaf_module_state:";
    private static final String OSGI_FRAMEWORK_MBEAN = "osgi.core:type=framework,*";
    private static final String OSGI_BUNDLESTATE_MBEAN = "osgi.core:type=bundleState,*";
    protected JMXServiceURL url;
    protected JMXConnector jmxc;
    protected MBeanServerConnection mbsc;
    protected ObjectName objectNameBundleState;
    protected ObjectName objectNameFramework;

    protected ControllableServerBehavior getServerBehavior(IServer server) {
        return (ControllableServerBehavior)server.loadAdapter(ControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean connect() {
        ObjectInstance oi;
        ObjectInstance oMbean;
        Set<ObjectInstance> mbeans;
        block7: {
            block6: {
                KarafServerDelegate del = (KarafServerDelegate)this.getServer().loadAdapter(KarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
                HashMap<String, String[]> envMap = new HashMap<String, String[]>();
                envMap.put("jmx.remote.credentials", new String[]{del.getUserName(), del.getPassword()});
                String conUrl = KarafUtils.getJMXConnectionURL(this.getServer());
                this.url = new JMXServiceURL(conUrl);
                this.jmxc = JMXConnectorFactory.connect(this.url, envMap);
                this.mbsc = this.jmxc.getMBeanServerConnection();
                this.objectNameBundleState = new ObjectName(OSGI_BUNDLESTATE_MBEAN);
                this.objectNameFramework = new ObjectName(OSGI_FRAMEWORK_MBEAN);
                mbeans = this.mbsc.queryMBeans(this.objectNameBundleState, null);
                if (mbeans.size() == 1) break block6;
                return false;
            }
            oMbean = mbeans.iterator().next();
            if (oMbean instanceof ObjectInstance) {
                oi = oMbean;
                this.objectNameBundleState = oi.getObjectName();
            }
            if ((mbeans = this.mbsc.queryMBeans(this.objectNameFramework, null)).size() == 1) break block7;
            return false;
        }
        try {
            oMbean = mbeans.iterator().next();
            if (oMbean instanceof ObjectInstance) {
                oi = oMbean;
                this.objectNameFramework = oi.getObjectName();
                return true;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return false;
    }

    protected boolean disconnect() {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
            }
            return true;
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.jmxc = null;
            this.mbsc = null;
            this.url = null;
        }
        return false;
    }

    protected long getBundleId(String bundleSymbolicName, String version) {
        try {
            TabularData tabData = (TabularData)this.mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String bsn = cd.get("SymbolicName").toString();
                String id = cd.get("Identifier").toString();
                String ver = cd.get("Version").toString();
                if (!(version != null ? bsn.equals(bundleSymbolicName) && ver.equals(version) : bsn.equals(bundleSymbolicName))) continue;
                return Long.parseLong(id);
            }
        }
        catch (Exception exception) {}
        return -1L;
    }

    protected int getBundleStatus(long bundleId) {
        try {
            TabularData tabData = (TabularData)this.mbsc.invoke(this.objectNameBundleState, "listBundles", null, null);
            Collection<?> rows = tabData.values();
            for (Object row : rows) {
                if (!(row instanceof CompositeData)) continue;
                CompositeData cd = (CompositeData)row;
                String id = cd.get("Identifier").toString();
                String state = cd.get("State").toString();
                long longID = Long.parseLong(id);
                if (bundleId != longID) continue;
                return OSGiBundleState.getStatusForString(state);
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public boolean canRestartModule(IModule[] module) {
        try {
            String key = BUNDLE_STATE_PREFIX + module.toString();
            Integer status = (Integer)this.getServerBehavior(this.getServer()).getSharedData(key);
            if (status == null) {
                return false;
            }
            boolean bl = status == 2 || status == 4;
            return bl;
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.executeModuleStateRequest(module);
        }
        return false;
    }

    private void executeModuleStateRequest(final IModule[] module) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String version;
                        String symbolicName;
                        long id;
                        if (OSGiBundleStateController.this.mbsc == null) {
                            OSGiBundleStateController.this.connect();
                        }
                        if ((id = OSGiBundleStateController.this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                            Integer status = OSGiBundleStateController.this.getBundleStatus(id);
                            String key = OSGiBundleStateController.BUNDLE_STATE_PREFIX + module.toString();
                            OSGiBundleStateController.this.getServerBehavior(OSGiBundleStateController.this.getServer()).putSharedData(key, (Object)status);
                        }
                    }
                    catch (Exception ex) {
                        Activator.getLogger().error((Throwable)ex);
                        OSGiBundleStateController.this.disconnect();
                    }
                }
                finally {
                    OSGiBundleStateController.this.disconnect();
                }
            }
        });
        t.start();
    }

    public int startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        try {
            String version;
            String symbolicName;
            long id;
            if (this.mbsc == null) {
                this.connect();
            }
            if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                this.mbsc.invoke(this.objectNameFramework, "startBundle", new Object[]{id}, new String[]{"long"});
                int n = this.getBundleStatus(id);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect();
        }
        return 0;
    }

    public int stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        try {
            String version;
            String symbolicName;
            long id;
            if (this.mbsc == null) {
                this.connect();
            }
            if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                this.mbsc.invoke(this.objectNameFramework, "stopBundle", new Object[]{id}, new String[]{"long"});
                int n = this.getBundleStatus(id);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect();
        }
        return 0;
    }

    public int restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        try {
            String version;
            String symbolicName;
            long id;
            if (this.mbsc == null) {
                this.connect();
            }
            if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                this.mbsc.invoke(this.objectNameFramework, "updateBundle", new Object[]{id}, new String[]{"long"});
                int n = this.getBundleStatus(id);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect();
        }
        return 0;
    }

    public int getModuleState(IModule[] module, IProgressMonitor monitor) {
        try {
            String version;
            String symbolicName;
            long id;
            if (this.mbsc == null) {
                this.connect();
            }
            if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                int n = this.getBundleStatus(id);
                return n;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect();
        }
        return 0;
    }

    public boolean isModuleStarted(IModule[] module, IProgressMonitor monitor) {
        try {
            String version;
            String symbolicName;
            long id;
            if (this.mbsc == null) {
                this.connect();
            }
            if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                boolean bl = this.getBundleStatus(id) == 2;
                return bl;
            }
        }
        catch (Exception ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        finally {
            this.disconnect();
        }
        return false;
    }

    public void waitModuleStarted(IModule[] module, IProgressMonitor monitor) {
        try {
            try {
                String version;
                String symbolicName;
                long id;
                if (this.mbsc == null) {
                    this.connect();
                }
                if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                    this.waitModuleStarted(symbolicName, version, id, monitor);
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                this.disconnect();
            }
        }
        finally {
            this.disconnect();
        }
    }

    public void waitModuleStarted(IModule[] module, int maxDelay) {
        try {
            try {
                String version;
                String symbolicName;
                long id;
                if (this.mbsc == null) {
                    this.connect();
                }
                if ((id = this.getBundleId(symbolicName = KarafUtils.getBundleSymbolicName(module[0]), version = KarafUtils.getBundleVersion(module[0], null))) != -1L) {
                    this.waitModuleStarted(symbolicName, version, id, maxDelay);
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                this.disconnect();
            }
        }
        finally {
            this.disconnect();
        }
    }

    protected void waitModuleStarted(String bundleSymbolicName, String version, long bundleId, IProgressMonitor monitor) {
        try {
            boolean waitedOnce = false;
            while (!monitor.isCanceled()) {
                boolean done;
                boolean bl = done = this.getBundleStatus(bundleId) == 2;
                if (done) {
                    return;
                }
                if (!waitedOnce) {
                    String info = "Module {0} on {1} not yet fully deployed. Waiting...";
                    Status s = new Status(1, "org.fusesource.ide.server.karaf.core", NLS.bind((String)info, (Object)bundleSymbolicName, (Object)this.getServer().getName()), null);
                    Activator.getDefault().getLog().log((IStatus)s);
                }
                waitedOnce = true;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String warning = "Module {0} on {1} still not ready. Aborting delay.";
            Status s = new Status(2, "org.fusesource.ide.server.karaf.core", NLS.bind((String)warning, (Object)bundleSymbolicName, (Object)this.getServer().getName()), null);
            Activator.getDefault().getLog().log((IStatus)s);
        }
        catch (Exception e) {
            String er = "Error occurred while waiting for {0} to start on server {1}";
            Status s = new Status(2, "org.fusesource.ide.server.karaf.core", NLS.bind((String)er, (Object)bundleSymbolicName, (Object)this.getServer().getName()), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitModuleStarted(String bundleSymbolicName, String version, long bundleId, final long maxDelay) {
        final NullProgressMonitor monitor = new NullProgressMonitor();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(maxDelay);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                NullProgressMonitor nullProgressMonitor = monitor;
                synchronized (nullProgressMonitor) {
                    monitor.setCanceled(true);
                }
            }
        };
        t.start();
        this.waitModuleStarted(bundleSymbolicName, version, bundleId, (IProgressMonitor)monitor);
        NullProgressMonitor nullProgressMonitor = monitor;
        synchronized (nullProgressMonitor) {
            if (!monitor.isCanceled()) {
                t.interrupt();
            }
        }
    }
}

