/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.tm.terminal.connector.ssh.launcher.SshLauncherDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;
import org.fusesource.ide.server.karaf.core.Messages;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.ui.KarafUIPlugin;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;

public class SshConnector {
    private static HashMap<IServer, SshConnector> connectors = new HashMap();
    private int port;
    private String host;
    private String userName;
    private String passwd;
    private IServer server;
    private IControllableServerBehavior behaviorDelegate;
    private static final String TERMINAL_VIEW_LABEL = Messages.shellViewLabel;

    public SshConnector(IServer server) {
        this.server = server;
        this.behaviorDelegate = (IControllableServerBehavior)server.loadAdapter(IControllableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
        IKarafServerDelegate config = (IKarafServerDelegate)server.loadAdapter(IKarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        this.host = server.getHost();
        this.port = config.getPortNumber();
        this.userName = config.getUserName();
        this.passwd = config.getPassword();
    }

    public SshConnector(IServer server, IControllableServerBehavior behaviorDelegate, String host, int port, String user, String pass) {
        this.server = server;
        this.behaviorDelegate = behaviorDelegate;
        this.host = host;
        this.port = port;
        this.userName = user;
        this.passwd = pass;
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        data.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.ssh.SshConnector");
        data.put("ip.host", this.host);
        data.put("ip.port", this.port);
        data.put("timeout", 0);
        data.put("ssh.keep_alive", 300);
        data.put("ssh.password", this.passwd);
        data.put("ssh.user", this.userName);
        data.put("encoding", StandardCharsets.UTF_8.name());
    }

    public void start() {
        IViewPart vp = KarafUIPlugin.openTerminalView();
        if (vp == null) {
            KarafUIPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.extractData(properties);
        properties.put("delegateId", "org.eclipse.tm.terminal.connector.ssh.launcher.ssh");
        SshLauncherDelegate delegate = new SshLauncherDelegate();
        delegate.execute(properties, null);
    }

    public void onConnect() {
        connectors.put(this.server, this);
        KarafUIPlugin.openTerminalView().setFocus();
    }

    public void onDisconnect() {
        IViewPart vp = KarafUIPlugin.openTerminalView();
        if (vp == null) {
            KarafUIPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        connectors.remove(this.server);
    }

    public static SshConnector getConnectorForServer(IServer server) {
        return connectors.get(server);
    }
}

