/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.editor;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegateWorkingCopy;
import org.fusesource.ide.server.karaf.ui.Messages;
import org.fusesource.ide.server.karaf.ui.editor.PortNumberChangeOperation;
import org.fusesource.ide.server.karaf.ui.editor.UserNameChangeOperation;
import org.jboss.ide.eclipse.as.wtp.ui.editor.ServerWorkingCopyPropertyCommand;

public class ConnectionDetailsEditorSection
extends ServerEditorSection {
    IKarafServerDelegateWorkingCopy configuration = null;
    private static final String PASSWORD_NOT_LOADED = "***fuseide****";
    private String passwordString = "***fuseide****";
    private boolean passwordChanged = false;
    private Text sshPasswordText;
    private ModifyListener sshPasswordListener;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.configuration = (IKarafServerDelegateWorkingCopy)this.server.loadAdapter(IKarafServerDelegateWorkingCopy.class, null);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 394);
        section.setText(Messages.ConnectionDetailsEditorSection_section_name);
        section.setDescription(Messages.ConnectionDetailsEditorSection_section_desc);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData filldata = new GridData(1808);
        GridData leftData = new GridData(16384);
        leftData.widthHint = 100;
        composite.setLayoutData((Object)filldata);
        section.setClient((Control)composite);
        if (this.configuration == null) {
            section.setDescription(Messages.ConnectionDetailsEditorSection_no_srv_conn);
            return;
        }
        Label portNumber = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_port_num_label);
        portNumber.setLayoutData((Object)leftData);
        final Text portNumberText = toolkit.createText(composite, Integer.toString(this.configuration.getPortNumber()), 2048);
        portNumberText.setLayoutData((Object)filldata);
        portNumberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int parseInt = Integer.parseInt(portNumberText.getText().trim());
                    ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new PortNumberChangeOperation(ConnectionDetailsEditorSection.this.configuration, parseInt, Messages.ConnectionDetailsEditorSection_port_num_op));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        Label sshUserNameLabel = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_user_name_label);
        sshUserNameLabel.setLayoutData((Object)leftData);
        final Text sshUserNameText = toolkit.createText(composite, this.configuration.getUserName(), 2048);
        sshUserNameText.setLayoutData((Object)filldata);
        sshUserNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new UserNameChangeOperation(ConnectionDetailsEditorSection.this.configuration, sshUserNameText.getText(), Messages.ConnectionDetailsEditorSection_user_name_op));
            }
        });
        Label sshPasswordLabel = toolkit.createLabel(composite, Messages.ConnectionDetailsEditorSection_password_label);
        sshPasswordLabel.setLayoutData((Object)leftData);
        this.sshPasswordText = toolkit.createText(composite, PASSWORD_NOT_LOADED, 0x400800);
        this.sshPasswordText.setLayoutData((Object)filldata);
        this.sshPasswordListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionDetailsEditorSection.this.execute((IUndoableOperation)new SetPassCommand(ConnectionDetailsEditorSection.this.server));
            }
        };
        this.sshPasswordText.addModifyListener(this.sshPasswordListener);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.passwordChanged) {
            this.configuration.setPassword(this.passwordString);
            monitor.worked(100);
            this.passwordChanged = false;
        }
    }

    public class SetPassCommand
    extends ServerWorkingCopyPropertyCommand {
        public SetPassCommand(IServerWorkingCopy server) {
            super(server, Messages.ConnectionDetailsEditorSection_password_op, ConnectionDetailsEditorSection.this.sshPasswordText, ConnectionDetailsEditorSection.this.sshPasswordText.getText(), null, ConnectionDetailsEditorSection.this.sshPasswordListener);
            this.oldVal = ConnectionDetailsEditorSection.this.passwordString;
        }

        public void execute() {
            ConnectionDetailsEditorSection.this.passwordString = this.newVal;
            ConnectionDetailsEditorSection.this.passwordChanged = !ConnectionDetailsEditorSection.PASSWORD_NOT_LOADED.equals(ConnectionDetailsEditorSection.this.passwordString);
        }

        public void undo() {
            ConnectionDetailsEditorSection.this.passwordString = this.oldVal;
            this.text.removeModifyListener(this.listener);
            this.text.setText(this.oldVal);
            this.text.addModifyListener(this.listener);
            ConnectionDetailsEditorSection.this.passwordChanged = !ConnectionDetailsEditorSection.PASSWORD_NOT_LOADED.equals(ConnectionDetailsEditorSection.this.passwordString);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable adapt) {
            this.execute();
            return Status.OK_STATUS;
        }
    }
}

