/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.fusesource.ide.server.karaf.core.Activator;
import org.fusesource.ide.server.karaf.core.runtime.IKarafRuntime;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegate;
import org.fusesource.ide.server.karaf.core.server.IKarafServerDelegateWorkingCopy;
import org.fusesource.ide.server.karaf.core.util.KarafUtils;
import org.fusesource.ide.server.karaf.ui.runtime.KarafServerPorpertiesComposite;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;

public abstract class AbstractKarafServerWizardFragment
extends WizardFragment {
    private KarafServerPorpertiesComposite composite = null;
    protected KarafWizardDataModel model = null;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.getWizardModel();
        this.composite = new KarafServerPorpertiesComposite(parent, handle, this.model);
        this.composite.createContents();
        return this.composite;
    }

    public boolean hasComposite() {
        return true;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        super.performFinish(monitor);
        this.composite.performFinish();
        this.updateServer();
    }

    private IRuntime getRuntimeWorkingCopy() {
        return (IRuntime)this.getTaskModel().getObject("runtime");
    }

    private IServerWorkingCopy getServerWorkingCopy() {
        return (IServerWorkingCopy)this.getTaskModel().getObject("server");
    }

    private void getWizardModel() {
        Object objModel = this.getTaskModel().getObject("karaf-model");
        this.model = objModel instanceof KarafWizardDataModel ? (KarafWizardDataModel)objModel : new KarafWizardDataModel();
        this.populateModel();
    }

    private void populateModel() {
        IServerWorkingCopy workingCopy = this.getServerWorkingCopy();
        if (this.model != null && workingCopy != null) {
            IKarafRuntime karafRuntime;
            IRuntime runtime;
            IKarafServerDelegate karafServerWorkingCopy = (IKarafServerDelegate)workingCopy.loadAdapter(IKarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (karafServerWorkingCopy != null) {
                this.model.setUserName(karafServerWorkingCopy.getUserName());
                this.model.setPassword(karafServerWorkingCopy.getPassword());
            }
            if ((runtime = this.getRuntimeWorkingCopy()) != null && (karafRuntime = (IKarafRuntime)runtime.loadAdapter(IKarafRuntime.class, null)) != null && ("".equals(this.model.getKarafInstallDir()) || this.model.getKarafInstallDir() == null)) {
                this.model.setKarafInstallDir(karafRuntime.getLocation().toOSString());
            }
            if (karafServerWorkingCopy != null) {
                this.model.setPortNumber(karafServerWorkingCopy.getPortNumber());
            }
        }
    }

    private void updateServer() {
        IKarafServerDelegateWorkingCopy karafServerWorkingCopy;
        IServerWorkingCopy workingCopy = this.getServerWorkingCopy();
        if (workingCopy != null && (karafServerWorkingCopy = (IKarafServerDelegateWorkingCopy)workingCopy.loadAdapter(IKarafServerDelegateWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor())) != null) {
            karafServerWorkingCopy.setPortNumber(this.model.getPortNumber());
            karafServerWorkingCopy.setUserName(this.model.getUserName());
            karafServerWorkingCopy.setPassword(this.model.getPassword());
            workingCopy.setRuntime(this.getRuntimeWorkingCopy());
            try {
                workingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
    }

    protected abstract void readFromPropertiesFile(File var1) throws FileNotFoundException, IOException, NumberFormatException;

    protected String determineVersion(IKarafRuntime runtime) {
        String version = null;
        if (runtime != null && runtime.getLocation() != null) {
            File folder = runtime.getLocation().toFile();
            version = KarafUtils.getVersion((File)folder);
        }
        return version;
    }

    public boolean isComplete() {
        if (this.composite == null || this.composite.isDisposed()) {
            return false;
        }
        return this.composite.isValid();
    }
}

