/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.fusesource.ide.server.karaf.ui.Messages;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;

public class KarafServerPorpertiesComposite
extends Composite
implements Listener {
    private final IWizardHandle wizardHandle;
    private final KarafWizardDataModel model;
    private Text txtUserName;
    private Text txtPortNumber;
    private Text txtPassword;
    private boolean valid = true;

    public KarafServerPorpertiesComposite(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, 0);
        this.wizardHandle = wizardHandle;
        this.model = model;
        wizardHandle.setTitle(Messages.KarafServerPorpertiesComposite_wizard_title);
        wizardHandle.setDescription(Messages.KarafServerPorpertiesComposite_wizard_desc);
        wizardHandle.setImageDescriptor(ImageResource.getImageDescriptor((String)"newServerWiz"));
    }

    public void handleEvent(Event event) {
        boolean val = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtPortNumber) {
            val = this.validate();
            if (val) {
                try {
                    this.model.setPortNumber(Integer.parseInt(this.txtPortNumber.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (event.widget == this.txtUserName) {
            this.model.setUserName(this.txtUserName.getText());
        } else if (event.widget == this.txtPassword) {
            this.model.setPassword(this.txtPassword.getText());
        }
        this.wizardHandle.update();
    }

    private void handleFocusEvent(Event event) {
    }

    protected boolean validate() {
        try {
            Integer.parseInt(this.txtPortNumber.getText().trim());
            this.valid = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
        return this.valid;
    }

    void createContents() {
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Label lblPortNumber = new Label((Composite)this, 0);
        lblPortNumber.setText(Messages.KarafServerPorpertiesComposite_port_number_label);
        this.txtPortNumber = new Text((Composite)this, 2048);
        this.txtPortNumber.setText(Integer.toString(this.model.getPortNumber()));
        this.txtPortNumber.setLayoutData((Object)gd);
        this.txtPortNumber.setTextLimit(5);
        this.txtPortNumber.addListener(24, (Listener)this);
        Label lblUserName = new Label((Composite)this, 0);
        lblUserName.setText(Messages.KarafServerPorpertiesComposite_user_name_label);
        this.txtUserName = new Text((Composite)this, 2048);
        this.txtUserName.setText(this.model.getUserName() != null ? this.model.getUserName() : "");
        this.txtUserName.setLayoutData((Object)gd);
        this.txtUserName.addListener(24, (Listener)this);
        Label lblPassword = new Label((Composite)this, 0);
        lblPassword.setText(Messages.KarafServerPorpertiesComposite_password_label);
        this.txtPassword = new Text((Composite)this, 0x400800);
        this.txtPassword.setText(this.model.getPassword() != null ? this.model.getPassword() : "");
        this.txtPassword.setLayoutData((Object)gd);
        this.txtPassword.addListener(24, (Listener)this);
        this.wizardHandle.update();
    }

    void performFinish() {
    }

    protected boolean isValid() {
        return this.valid;
    }
}

