/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.karaf.ui.runtime;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.fusesource.ide.server.karaf.ui.Messages;

public class RTIComposite
extends Composite
implements Listener {
    protected TaskModel taskModel;
    protected IWizardHandle wizardHandle;
    protected Text fuseRTLoc;
    Button browseButton;
    Boolean valid = false;

    public RTIComposite(Composite parent, TaskModel taskModel, IWizardHandle wizard) {
        super(parent, 0);
        this.taskModel = taskModel;
        this.wizardHandle = wizard;
        this.createControl();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fuseRTLoc && this.validate()) {
            this.taskModel.putObject("fuseRTLoc", (Object)this.fuseRTLoc.getText());
        }
    }

    public boolean validate() {
        this.valid = false;
        String dirLocation = this.fuseRTLoc.getText().trim();
        if (dirLocation != null && !dirLocation.isEmpty()) {
            File file = new File(dirLocation);
            if (!file.exists()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
            } else if (!file.isDirectory()) {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
            } else {
                this.valid = true;
                this.wizardHandle.setMessage("", 0);
            }
        } else {
            this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
        }
        return this.valid;
    }

    public boolean isComplete() {
        return this.valid;
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        Label l = new Label((Composite)this, 64);
        l.setText("Target Folder:");
        this.fuseRTLoc = new Text((Composite)this, 2052);
        this.fuseRTLoc.addListener(24, (Listener)this);
        GridData fuseRTLocGridData = new GridData();
        fuseRTLocGridData.grabExcessHorizontalSpace = true;
        fuseRTLocGridData.horizontalAlignment = 4;
        this.fuseRTLoc.setLayoutData((Object)fuseRTLocGridData);
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText(Messages.AbstractKarafRuntimeComposite_browse_text);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(RTIComposite.this.browseButton.getShell(), 4096);
                dlg.setFilterPath(RTIComposite.this.fuseRTLoc.getText());
                String path = dlg.open();
                if (path != null) {
                    RTIComposite.this.fuseRTLoc.setText(path);
                }
            }
        });
    }
}

