/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.jdt.integration.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.jdt.integration.model.IArchiveLibFileSet;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibFilesetInfoWizardPage
extends WizardPage {
    private IArchiveNode parentNode;
    private IArchiveLibFileSet fileset;
    private String projectName;
    private String id;
    private Composite mainComposite;
    private TreeViewer viewer;
    private ArrayList<CPUserLibraryElement> elements;

    public LibFilesetInfoWizardPage(Shell parent, IArchiveLibFileSet fileset, IArchiveNode parentNode) {
        super(ArchivesUIMessages.LibFilesetInfoWizardPage_new_title, ArchivesUIMessages.LibFilesetInfoWizardPage_new_title, null);
        if (fileset == null) {
            this.setTitle(ArchivesUIMessages.LibFilesetInfoWizardPage_new_title);
            this.setMessage(ArchivesUIMessages.LibFilesetInfoWizardPage_new_message);
        } else {
            this.setTitle(ArchivesUIMessages.LibFilesetInfoWizardPage_edit_title);
            this.setMessage(ArchivesUIMessages.LibFilesetInfoWizardPage_edit_message);
        }
        this.fileset = fileset;
        this.parentNode = parentNode;
        this.projectName = parentNode.getProjectName();
    }

    public void createControl(Composite parent) {
        CPUserLibraryElement e;
        String id;
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.mainComposite, 2052);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CPListLabelProvider());
        this.elements = this.getElementList(LibFilesetInfoWizardPage.createPlaceholderProject());
        this.viewer.setInput(new Object());
        String string = id = this.fileset == null ? null : this.fileset.getId();
        if (id != null && (e = this.findElement(id, this.elements)) != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(new Object[]{e}));
        }
        this.addListener();
        this.setControl((Control)this.mainComposite);
    }

    protected void addListener() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (LibFilesetInfoWizardPage.this.getFirstElement() instanceof CPUserLibraryElement) {
                    LibFilesetInfoWizardPage.this.id = ((CPUserLibraryElement)LibFilesetInfoWizardPage.this.getFirstElement()).getName();
                }
                LibFilesetInfoWizardPage.this.validate();
            }
        });
    }

    protected Object getFirstElement() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel.getFirstElement();
    }

    protected ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof CPUserLibraryElement) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)element;
                    return elem.getChildren();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof CPListElementAttribute) {
                    return ((CPListElementAttribute)element).getParent();
                }
                if (element instanceof CPListElement) {
                    return ((CPListElement)element).getParentContainer();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return LibFilesetInfoWizardPage.this.elements.toArray(new Object[LibFilesetInfoWizardPage.this.elements.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private CPUserLibraryElement findElement(String name, ArrayList<CPUserLibraryElement> elements) {
        Iterator<CPUserLibraryElement> it = elements.iterator();
        CPUserLibraryElement e = null;
        while (it.hasNext()) {
            e = it.next();
            if (!name.equals(e.getName())) continue;
            return e;
        }
        return null;
    }

    protected ArrayList<CPUserLibraryElement> getElementList(IJavaProject fDummyProject) {
        String[] names = JavaCore.getUserLibraryNames();
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>();
        int i = 0;
        while (i < names.length) {
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(names[i]);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)fDummyProject);
                elements.add(new CPUserLibraryElement(names[i], container, fDummyProject));
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        return elements;
    }

    private static IJavaProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    private boolean validate() {
        if (!(this.getFirstElement() instanceof CPUserLibraryElement)) {
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        return true;
    }

    public String getId() {
        return this.id;
    }

    protected double getDescriptorVersion() {
        return this.parentNode.getModelRootNode().getDescriptorVersion();
    }
}

